/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.IOException;
import java.sql.SQLException;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

class LoadError {
    LoadError() {
    }

    static SQLException connectionNull() {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE01.S", new Object[0]));
    }

    static SQLException dataAfterStopDelimiter(int lineNumber, int columnNumber) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE03.S", lineNumber, columnNumber));
    }

    static SQLException dataFileNotFound(String fileName, Exception ex) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE04.S", ex, fileName));
    }

    static SQLException dataFileNull() {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE05.S", new Object[0]));
    }

    static SQLException dataFileExists(String fileName) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0S.S", fileName));
    }

    static SQLException lobsFileExists(String fileName) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0T.S", fileName));
    }

    static SQLException entityNameMissing() {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE06.S", new Object[0]));
    }

    static SQLException fieldAndRecordSeparatorsSubset() {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE07.S", new Object[0]));
    }

    static SQLException invalidColumnName(String columnName) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE08.S", columnName));
    }

    static SQLException invalidColumnNumber(int numberOfColumns) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE09.S", numberOfColumns));
    }

    static SQLException nonSupportedTypeColumn(String columnName, String typeName) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0B.S", columnName, typeName));
    }

    static SQLException recordSeparatorMissing(int lineNumber) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0D.S", lineNumber));
    }

    static SQLException unexpectedEndOfFile(int lineNumber) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0E.S", lineNumber));
    }

    static SQLException errorWritingData(IOException ioe) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0I.S", ioe, new Object[0]));
    }

    static SQLException periodAsCharDelimiterNotAllowed() {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0K.S", new Object[0]));
    }

    static SQLException delimitersAreNotMutuallyExclusive() {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0J.S", new Object[0]));
    }

    static SQLException tableNotFound(String tableName) {
        return PublicAPI.wrapStandardException(StandardException.newException("XIE0M.S", tableName));
    }

    static SQLException unexpectedError(Throwable t) {
        if (!(t instanceof SQLException)) {
            return PublicAPI.wrapStandardException(StandardException.plainWrapException(t));
        }
        return (SQLException)t;
    }
}

