/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem;

import com.ibm.icu.util.ULocale;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.reportitem.BIRTExternalContext;
import org.eclipse.birt.chart.reportitem.BIRTScriptClassLoader;
import org.eclipse.birt.chart.reportitem.ChartReportItemImpl;
import org.eclipse.birt.chart.reportitem.ChartReportItemUtil;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ReportItemGenerationBase;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;

public class ChartReportItemGenerationImpl
extends ReportItemGenerationBase {
    private Chart cm = null;
    private RunTimeContext rtc = null;
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.reportitem/trace");

    @Override
    public void setModelObject(ExtendedItemHandle eih) {
        super.setModelObject(eih);
        IReportItem item = null;
        try {
            item = eih.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(e);
        }
        if (item == null) {
            try {
                eih.loadExtendedElement();
                item = eih.getReportItem();
            }
            catch (ExtendedElementException eeex) {
                logger.log(eeex);
            }
            if (item == null) {
                logger.log(4, Messages.getString("ChartReportItemPresentationImpl.log.UnableToLocateWrapper"));
                return;
            }
        }
        this.cm = (Chart)((ChartReportItemImpl)item).getProperty("chart.instance");
    }

    @Override
    public void serialize(OutputStream ostream) throws BirtException {
        try {
            ObjectOutputStream oos = SecurityUtil.newObjectOutputStream(ostream);
            oos.writeObject(this.rtc);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            logger.log(e);
        }
    }

    @Override
    public boolean needSerialization() {
        return true;
    }

    @Override
    public void onRowSets(IBaseResultSet[] results) throws BirtException {
        if (this.modelHandle == null || this.cm == null) {
            return;
        }
        Bounds bo = this.cm.getBlock().getBounds();
        if (bo.getWidth() == 0.0 && bo.getHeight() == 0.0 && (bo.isSetHeight() || bo.isSetWidth())) {
            return;
        }
        String javaHandlerClass = this.modelHandle.getEventHandlerClass();
        if (javaHandlerClass != null && javaHandlerClass.length() > 0) {
            this.cm.setScript(javaHandlerClass);
        }
        this.rtc = Generator.instance().prepare(this.cm, (IExternalContext)new BIRTExternalContext(this.context), (IScriptClassLoader)new BIRTScriptClassLoader(this.appClassLoader), ULocale.getDefault());
        if (results != null && results.length != 0 && !ChartReportItemUtil.isEmpty(results[0]) && this.queries != null && this.queries.length != 0) {
            IDataQueryDefinition cfr_ignored_0 = this.queries[0];
        }
    }
}

