/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.UnsupportedEncodingException;
import java.util.Base64;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.writer.ModuleWriter;

class DesignWriterImpl
extends ModuleWriter {
    private ReportDesign design;

    public DesignWriterImpl(ReportDesign design) {
        this.design = design;
    }

    @Override
    public final void visitReportDesign(ReportDesign obj) {
        this.writer.startElement("report");
        super.visitReportDesign(obj);
        this.writeSimpleProperties(obj);
        this.writeSlot(obj);
        this.writeContentProperties(obj);
        this.writeImages(obj);
        this.writer.endElement();
    }

    @Override
    public Module getModule() {
        return this.design;
    }

    protected void writeSimpleProperties(ReportDesign obj) {
        this.property(obj, "refreshRate");
        this.property(obj, "initialize");
        this.property(obj, "onPrepare");
        this.property(obj, "beforeFactory");
        this.property(obj, "afterFactory");
        this.property(obj, "beforeRender");
        this.property(obj, "afterRender");
        this.property(obj, "onPageStart");
        this.property(obj, "onPageEnd");
        this.property(obj, "clientInitialize");
        if (this.markLineNumber) {
            this.getModule().addLineNo(obj.getPropertyDefn("theme"), this.writer.getLineCounter());
        }
        this.property(obj, "theme");
        this.resourceKey(obj, "displayNameID", "displayName");
        this.property(obj, "iconFile");
        this.property(obj, "cheatSheet");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "newHandlerOnEachEvent");
        this.property(obj, "layoutPreference");
        this.property(obj, "bidiLayoutOrientation");
        this.property(obj, "enableACL");
        this.property(obj, "ACLExpression");
        this.property(obj, "cascadeACL");
        this.property(obj, "imageDPI");
        this.property(obj, "locale");
        this.property(obj, "excelDisableGrouping");
        this.property(obj, "excelForceAutoColWidths");
        this.property(obj, "excelAutoColWidthsIncludeTableHeader");
        this.property(obj, "excelAutoColWidthsIncludeTableFooter");
        this.property(obj, "excelSingleSheet");
        this.property(obj, "excelDisplayGridlines");
        this.property(obj, "excelAutoFilter");
        this.property(obj, "excelForceRecalculation");
        this.property(obj, "excelImageScalingToCellDimension");
        this.property(obj, "excelSingleSheetWithPageBreaks");
        this.property(obj, "excelStreamingXlsx");
        this.property(obj, "excelStructuredHeader");
        this.property(obj, "excelPrintPagesHigh");
        this.property(obj, "excelPrintPagesWide");
        this.property(obj, "excelPrintScale");
        this.property(obj, "excelTemplateFile");
        this.property(obj, "pdfVersion");
        this.property(obj, "pdfConformance");
        this.property(obj, "pdfUAConformance");
        this.property(obj, "pdfIccColorType");
        this.property(obj, "pdfIccProfileExternal");
        this.property(obj, "pdfDocumentPrepend");
        this.property(obj, "pdfDocumentAppend");
        this.property(obj, "pdfaFontFallback");
        this.property(obj, "pdfaFontCidEmbed");
        this.property(obj, "pdfaDocumentTitleEmbed");
        this.property(obj, "wordCombineMarginPadding");
        this.property(obj, "wordAddEmptyParagraphForListCell");
        this.property(obj, "wordAddEmptyParagraphForTableCell");
        this.property(obj, "wordWrappedTableForMarginPadding");
        this.property(obj, "wordWrappedTableHeaderFooter");
        this.writeStructureList(obj, "libraries");
        this.writeStructureList(obj, "cssStyleSheets");
        this.writeStructureList(obj, "configVars");
    }

    protected void writeSlot(ReportDesign obj) {
        this.writeContents(obj, 8, "template-parameter-definitions");
        this.writeContents(obj, 1, "parameters");
        this.writeContents(obj, 2, "data-sources");
        this.writeContents(obj, 3, "data-sets");
        this.writeContents(obj, 9, "cubes");
        this.writeCustomColors(obj);
        this.writeTranslations(obj);
        this.writeContents(obj, 0, "styles");
        this.writeContents(obj, 10, "themes");
        this.writeArrangedContents(obj, 5, "components");
        this.writeContents(obj, 4, "page-setup");
        this.writeContents(obj, 6, "body");
        this.writeContents(obj, 7, "scratch-pad");
    }

    protected void writeContentProperties(ReportDesign obj) {
        this.writeContents(obj, "pageVariables");
        this.writeContents(obj, "dataObjects");
    }

    protected void writeImages(ReportDesign obj) {
        block6: {
            try {
                byte[] thumbnail = this.design.getThumbnail();
                if (thumbnail != null) {
                    byte[] data = Base64.getEncoder().encode(this.design.getThumbnail());
                    String value = null;
                    if (data != null) {
                        value = new String(data, "8859_1");
                    }
                    if (value != null && value.length() < 80) {
                        this.writeEntry("property", "thumbnail", null, value.trim(), false);
                    } else {
                        this.writeBase64Text("property", "thumbnail", value);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        this.writeEmbeddedImages(obj);
    }
}

