/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel.handlers;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IDataContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IImageContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.ITextContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import uk.co.spudsoft.birt.emitters.excel.Coordinate;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;
import uk.co.spudsoft.birt.emitters.excel.handlers.CellContentHandler;
import uk.co.spudsoft.birt.emitters.excel.handlers.IHandler;

public class NestedListContentHandler
extends CellContentHandler {
    protected int column;

    public NestedListContentHandler(IContentEmitter emitter, Logger log, IHandler parent, IListContent list, int column) {
        super(emitter, log, parent, null);
        this.element = list;
        this.column = column;
    }

    @Override
    public void emitText(HandlerState state, ITextContent text) throws BirtException {
        String textText = text.getText();
        this.log.debug("text:", textText);
        this.emitContent(state, text, textText, !"inline".equals(NestedListContentHandler.getStyleProperty(text, 63, "block")));
        state.setHandler(this.parent);
    }

    @Override
    public void emitData(HandlerState state, IDataContent data) throws BirtException {
        this.emitContent(state, data, data.getValue(), !"inline".equals(NestedListContentHandler.getStyleProperty(data, 63, "block")));
        state.setHandler(this.parent);
    }

    @Override
    public void emitLabel(HandlerState state, ILabelContent label) throws BirtException {
        String labelText = label.getText() != null ? label.getText() : label.getLabelText();
        this.log.debug("labelText:", labelText);
        this.emitContent(state, label, labelText, !"inline".equals(NestedListContentHandler.getStyleProperty(label, 63, "block")));
        state.setHandler(this.parent);
    }

    @Override
    public void emitAutoText(HandlerState state, IAutoTextContent autoText) throws BirtException {
        this.emitContent(state, autoText, autoText.getText(), !"inline".equals(NestedListContentHandler.getStyleProperty(autoText, 63, "block")));
        state.setHandler(this.parent);
    }

    @Override
    public void emitForeign(HandlerState state, IForeignContent foreign) throws BirtException {
        this.log.debug("Handling foreign content of type ", foreign.getRawType());
        if ("text/html".equalsIgnoreCase(foreign.getRawType())) {
            HTML2Content.html2Content(foreign);
            this.contentVisitor.visitChildren(foreign, null);
        }
        state.setHandler(this.parent);
    }

    @Override
    public void emitImage(HandlerState state, IImageContent image) throws BirtException {
        this.recordImage(state, new Coordinate(state.rowNum, this.column), image, false);
        this.lastElement = image;
        state.setHandler(this.parent);
    }
}

