/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf;

import org.openpdf.text.error_messages.MessageLocalization;
import org.openpdf.text.pdf.PdfArray;
import org.openpdf.text.pdf.PdfDictionary;
import org.openpdf.text.pdf.PdfIndirectReference;
import org.openpdf.text.pdf.PdfName;
import org.openpdf.text.pdf.PdfNumber;
import org.openpdf.text.pdf.PdfObject;
import org.openpdf.text.pdf.PdfStructureTreeRoot;

public class PdfStructureElement
extends PdfDictionary {
    private PdfStructureElement parent;
    private PdfStructureTreeRoot top;
    private PdfIndirectReference reference;

    public PdfStructureElement(PdfStructureElement parent, PdfName structureType) {
        this.top = parent.top;
        this.init(parent, structureType);
        this.parent = parent;
        this.put(PdfName.P, parent.reference);
        this.put(PdfName.TYPE, new PdfName("StructElem"));
    }

    public PdfStructureElement(PdfStructureTreeRoot parent, PdfName structureType) {
        this.top = parent;
        this.init(parent, structureType);
        this.put(PdfName.P, parent.getReference());
        this.put(PdfName.TYPE, new PdfName("StructElem"));
    }

    private void init(PdfDictionary parent, PdfName structureType) {
        PdfObject kido = parent.get(PdfName.K);
        PdfArray kids = null;
        if (kido != null && !kido.isArray()) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("the.parent.has.already.another.function"));
        }
        if (kido == null) {
            kids = new PdfArray();
            parent.put(PdfName.K, kids);
        } else {
            kids = (PdfArray)kido;
        }
        kids.add(this);
        this.put(PdfName.S, structureType);
        this.reference = this.top.getWriter().getPdfIndirectReference();
    }

    public PdfDictionary getParent() {
        return this.parent;
    }

    void setPageMark(int page, int mark) {
        if (mark >= 0) {
            this.put(PdfName.K, new PdfNumber(mark));
        }
        this.top.setPageMark(page, this.reference);
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }
}

