/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.extension.datafeed;

import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import org.eclipse.birt.chart.computation.ValueFormatter;
import org.eclipse.birt.chart.datafeed.NumberDataPointEntry;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.FormatSpecifier;
import org.eclipse.birt.chart.model.attribute.FractionNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.JavaNumberFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.NumberFormatSpecifier;
import org.eclipse.birt.chart.util.BigNumber;
import org.eclipse.birt.chart.util.NumberUtil;

public final class BubbleEntry
extends NumberDataPointEntry {
    private static ILogger logger = Logger.getLogger("org.eclipse.birt.chart.engine.extension/render");
    private Object oValue;
    private double dSize;
    private BigNumber bnSize;
    private Number bdSize;
    private boolean bIsBigNumber = false;
    private boolean bIsBigDecimal = false;
    private com.ibm.icu.math.BigDecimal divisor;
    private int index = 0;

    public BubbleEntry(Object value, Object size, int index) {
        this(value, size);
        this.index = index;
    }

    public BubbleEntry(Object value, Object size) {
        this.init(value, size);
    }

    private void init(Object value, Object size) {
        if (NumberUtil.isBigNumber(value)) {
            this.bIsBigNumber = true;
            this.divisor = ((BigNumber)value).getDivisor();
            this.bnSize = (BigNumber)size;
        } else if (NumberUtil.isBigDecimal(value)) {
            this.bIsBigDecimal = true;
            this.bdSize = NumberUtil.isJavaMathBigDecimal(value) ? NumberUtil.asJavaMathBigDecimal((Number)size) : NumberUtil.asBigDecimal((Number)size);
        }
        this.oValue = value;
        if (value instanceof Double && ((Double)value).isNaN()) {
            this.oValue = null;
        }
        this.dSize = size instanceof Number ? ((Number)size).doubleValue() : 0.0;
    }

    public String toString() {
        return this.getFormattedString(null, ULocale.getDefault());
    }

    public Object getValue() {
        if (this.index > 0) {
            return this.index;
        }
        return this.oValue;
    }

    public void setValue(Object value) {
        this.oValue = value;
        if (NumberUtil.isBigNumber(value)) {
            this.bIsBigNumber = true;
            this.divisor = ((BigNumber)value).getDivisor();
        } else {
            this.bIsBigNumber = false;
        }
    }

    public double getSize() {
        return this.bIsBigNumber ? this.bnSize.doubleValue() : this.dSize;
    }

    public Number getSizeNumber() {
        if (this.bIsBigNumber) {
            return this.bnSize;
        }
        if (this.bIsBigDecimal) {
            return this.bdSize;
        }
        return this.dSize;
    }

    public void setSize(double dSize) {
        this.dSize = dSize;
    }

    public void setSize(Number size) {
        if (NumberUtil.isBigNumber(size)) {
            this.dSize = ((BigNumber)size).doubleValue();
            this.bnSize = (BigNumber)size;
            return;
        }
        this.setSize(size.doubleValue());
    }

    @Override
    public String getFormattedString(String type, FormatSpecifier formatter, ULocale locale) {
        String str = null;
        try {
            if ("bubble_value".equals(type)) {
                str = ValueFormatter.format(this.oValue, formatter, locale, null);
            } else if ("bubble_size".equals(type)) {
                Number size = null;
                size = this.bIsBigNumber ? this.bnSize : new Double(this.dSize);
                str = ValueFormatter.format(size, formatter, locale, null);
            }
        }
        catch (ChartException e) {
            logger.log(e);
        }
        return str;
    }

    @Override
    public String getFormattedString(FormatSpecifier formatter, ULocale locale) {
        String strSize;
        String string = strSize = this.bIsBigNumber ? String.valueOf(this.bnSize) : String.valueOf(this.dSize);
        if (formatter instanceof NumberFormatSpecifier || formatter instanceof JavaNumberFormatSpecifier || formatter instanceof FractionNumberFormatSpecifier) {
            try {
                strSize = ValueFormatter.format(this.bIsBigNumber ? this.bnSize : Double.valueOf(this.dSize), formatter, locale, null);
            }
            catch (ChartException e) {
                logger.log(e);
            }
        }
        String strValue = "";
        try {
            if (this.oValue == null) {
                return "S" + strSize;
            }
            strValue = ValueFormatter.format(this.oValue, formatter, locale, null);
        }
        catch (ChartException e) {
            logger.log(e);
        }
        return "Y" + strValue + " S" + strSize;
    }

    @Override
    public boolean isValid() {
        if (!this.bIsBigNumber) {
            return this.getValue() != null && !Double.isNaN(this.dSize) && this.dSize != 0.0;
        }
        return this.bnSize != null && this.bnSize.doubleValue() != 0.0;
    }

    public boolean isBigNumber() {
        return this.bIsBigNumber;
    }

    public com.ibm.icu.math.BigDecimal getDivisor() {
        return this.divisor;
    }

    @Override
    public void setNumberData(Number[] data) {
        if (data == null || data.length < 2) {
            return;
        }
        this.init(data[0], data[1]);
    }

    @Override
    public Number[] getNumberData() {
        if (this.bIsBigNumber) {
            return new BigNumber[]{(BigNumber)this.oValue, this.bnSize};
        }
        if (this.bIsBigDecimal) {
            if (this.oValue instanceof com.ibm.icu.math.BigDecimal) {
                return new com.ibm.icu.math.BigDecimal[]{(com.ibm.icu.math.BigDecimal)this.oValue, (com.ibm.icu.math.BigDecimal)this.bdSize};
            }
            return new BigDecimal[]{(BigDecimal)this.oValue, (BigDecimal)this.bdSize};
        }
        if (this.oValue instanceof Number) {
            return new Double[]{((Number)this.oValue).doubleValue(), this.dSize};
        }
        return null;
    }
}

