/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.ArchiveLockManager;
import org.eclipse.birt.core.archive.ArchiveUtil;
import org.eclipse.birt.core.archive.FolderArchiveEntry;
import org.eclipse.birt.core.archive.IArchiveLockManager;
import org.eclipse.birt.core.archive.RAFolderInputStream;
import org.eclipse.birt.core.archive.RAFolderOutputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveEntry;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.i18n.CoreMessages;
import org.eclipse.birt.core.util.IOUtil;

public class FolderArchiveFile
implements IArchiveFile {
    private static final String METEDATA = ".metadata";
    private static Logger logger = Logger.getLogger(FolderArchiveFile.class.getName());
    protected String folderName;
    protected String systemId;
    protected String dependId;
    private HashSet<RAFolderInputStream> inputStreams = new HashSet();
    private HashSet<RAFolderOutputStream> outputStreams = new HashSet();
    protected Map<String, String> properties = new HashMap<String, String>();

    public FolderArchiveFile(String name) throws IOException {
        if (name == null || name.length() == 0) {
            throw new IOException(CoreMessages.getString("error.FolderNameIsNull"));
        }
        File file = new File(name);
        file.mkdirs();
        this.folderName = file.getCanonicalPath();
        this.readMetaData();
    }

    @Override
    public String getName() {
        return this.folderName;
    }

    private void readMetaData() throws IOException {
        String meta = ArchiveUtil.getFullPath(this.folderName, METEDATA);
        File file = new File(meta);
        if (file.exists() && file.isFile()) {
            DataInputStream data = new DataInputStream(new FileInputStream(file));
            Throwable throwable = null;
            Object var5_6 = null;
            try {
                try {
                    this.properties = IOUtil.readMap(data);
                }
                finally {
                    if (data != null) {
                        data.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private void saveMetaData() throws IOException {
        String meta = ArchiveUtil.getFullPath(this.folderName, METEDATA);
        File file = new File(meta);
        DataOutputStream data = new DataOutputStream(new FileOutputStream(file));
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            try {
                IOUtil.writeMap(data, this.properties);
            }
            finally {
                if (data != null) {
                    data.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.saveMetaData();
        IOException exception = null;
        HashSet<Closeable> hashSet = this.outputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderOutputStream> outputs = new ArrayList<RAFolderOutputStream>(this.outputStreams);
            for (RAFolderOutputStream output : outputs) {
                try {
                    output.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (exception == null) continue;
                    exception = ex;
                }
            }
            this.outputStreams.clear();
        }
        hashSet = this.inputStreams;
        synchronized (hashSet) {
            ArrayList<RAFolderInputStream> inputs = new ArrayList<RAFolderInputStream>(this.inputStreams);
            for (RAFolderInputStream input : inputs) {
                try {
                    input.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (exception == null) continue;
                    exception = ex;
                }
            }
            this.inputStreams.clear();
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        IOException ioex = null;
        HashSet<RAFolderOutputStream> hashSet = this.outputStreams;
        synchronized (hashSet) {
            for (RAOutputStream rAOutputStream : this.outputStreams) {
                try {
                    rAOutputStream.flush();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    if (ioex == null) continue;
                    ioex = ex;
                }
            }
        }
        if (ioex != null) {
            throw ioex;
        }
    }

    @Override
    public void refresh() throws IOException {
    }

    @Override
    public boolean exists(String name) {
        String path = this.getFilePath(name);
        File fd = new File(path);
        return fd.exists();
    }

    @Override
    public void setCacheSize(long cacheSize) {
    }

    @Override
    public long getUsedCache() {
        return 0L;
    }

    @Override
    public ArchiveEntry openEntry(String name) throws IOException {
        String fullPath = this.getFilePath(name);
        File fd = new File(fullPath);
        if (fd.exists()) {
            return new FolderArchiveEntry(name, fd, this.inputStreams, this.outputStreams);
        }
        throw new FileNotFoundException(fullPath);
    }

    @Override
    public List<String> listEntries(String namePattern) {
        ArrayList<String> streamList = new ArrayList<String>();
        String storagePath = this.getFolderPath(namePattern);
        ArrayList files = new ArrayList();
        ArchiveUtil.listAllFiles(new File(storagePath), files);
        for (File file : files) {
            String relativePath = ArchiveUtil.getRelativePath(this.folderName, file.getPath());
            if (ArchiveUtil.needSkip(relativePath)) continue;
            String entryName = ArchiveUtil.getEntryName(this.folderName, file.getPath());
            streamList.add(entryName);
        }
        return streamList;
    }

    @Override
    public ArchiveEntry createEntry(String name) throws IOException {
        String path = this.getFilePath(name);
        File fd = new File(path);
        ArchiveUtil.createParentFolder(fd);
        FolderArchiveEntry out = new FolderArchiveEntry(name, fd, this.inputStreams, this.outputStreams);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeEntry(String name) throws IOException {
        HashSet<RAFolderOutputStream> hashSet;
        boolean bl;
        String path = this.getFilePath(name);
        try {
            File fd = new File(path);
            bl = ArchiveUtil.removeFileAndFolder(fd);
            hashSet = this.outputStreams;
        }
        catch (Throwable throwable) {
            HashSet<RAFolderOutputStream> hashSet2 = this.outputStreams;
            synchronized (hashSet2) {
                ArrayList<RAFolderOutputStream> outputs = new ArrayList<RAFolderOutputStream>(this.outputStreams);
                for (RAFolderOutputStream output : outputs) {
                    try {
                        if (!name.equals(output.getName())) continue;
                        output.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                        throw ex;
                    }
                }
            }
        }
        synchronized (hashSet) {
            ArrayList<RAFolderOutputStream> outputs = new ArrayList<RAFolderOutputStream>(this.outputStreams);
            for (RAFolderOutputStream output : outputs) {
                try {
                    if (!name.equals(output.getName())) continue;
                    output.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    throw ex;
                }
            }
        }
        return bl;
        throw throwable;
    }

    @Override
    public Object lockEntry(String entry) throws IOException {
        String path = this.getFilePath(entry) + ".lck";
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        return lockManager.lock(path);
    }

    @Override
    public void unlockEntry(Object locker) throws IOException {
        IArchiveLockManager lockManager = ArchiveLockManager.getInstance();
        lockManager.unlock(locker);
    }

    @Override
    public String getSystemId() {
        if (this.properties.containsKey("archive.system-id")) {
            return this.properties.get("archive.system-id").toString();
        }
        return null;
    }

    @Override
    public String getDependId() {
        if (this.properties.containsKey("archive.depened-id")) {
            return this.properties.get("archive.depened-id").toString();
        }
        return null;
    }

    public void setSystemId(String systemId) {
        if (systemId != null) {
            this.properties.put("archive.system-id", systemId);
        }
    }

    public void setDependId(String dependId) {
        if (dependId != null) {
            this.properties.put("archive.depened-id", dependId);
        }
    }

    @Override
    public void save() throws IOException {
        this.flush();
    }

    @Override
    public long getLength() {
        long result = 0L;
        List<String> entries = this.listEntries(null);
        for (String entry : entries) {
            try {
                result += this.openEntry(entry).getLength();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private String getFilePath(String entryName) {
        return ArchiveUtil.getFilePath(this.folderName, entryName);
    }

    private String getFolderPath(String entryName) {
        return ArchiveUtil.getFolderPath(this.folderName, entryName);
    }
}

