/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IBundle;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.IPlatform;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.IPlatformPath;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.framework.PlatformFileContext;
import org.eclipse.birt.core.framework.PlatformLauncher;
import org.eclipse.birt.core.framework.jar.ServiceLauncher;
import org.eclipse.birt.core.framework.osgi.OSGILauncher;
import org.eclipse.core.runtime.IAdapterManager;

public class Platform {
    @Deprecated
    public static final String PROPERTY_RUN_UNDER_ECLIPSE = "RUN_UNDER_ECLIPSE";
    public static final String PROPERTY_BIRT_HOME = "BIRT_HOME";
    public static int UNKNOWN_PLATFORM = 0;
    public static int ECLIPSE_PLATFORM = 1;
    @Deprecated
    public static final int SERVER_PLATFORM = 2;
    public static int JAVA_PLATFORM = 3;
    protected static int platformType = UNKNOWN_PLATFORM;
    protected static IPlatform platform = null;
    protected static PlatformLauncher launcher = null;
    protected static Logger log = Logger.getLogger(Platform.class.getName());

    public static synchronized void startup() throws BirtException {
        Platform.startup(new PlatformConfig());
    }

    public static synchronized void startup(PlatformConfig config) throws BirtException {
        if (platform == null) {
            try {
                launcher = Platform.createPlatformLauncher(config);
                launcher.startup(config);
                assert (platform != null);
            }
            catch (Exception ex) {
                platform = null;
                throw new BirtException("org.eclipse.birt.core", "error.CannotStartupOSGIPlatform", null, (Throwable)ex);
            }
        }
    }

    protected static PlatformLauncher createPlatformLauncher(PlatformConfig config) {
        IPlatformContext context;
        if (config == null) {
            config = new PlatformConfig();
        }
        if ((context = config.getPlatformContext()) != null) {
            String platform = context.getPlatform();
            if (platform == null) {
                return new ServiceLauncher();
            }
            return new OSGILauncher();
        }
        PlatformFileContext fileContext = new PlatformFileContext(config);
        if (OSGILauncher.isValidPlatform(fileContext)) {
            config.setPlatformContext(fileContext);
            return new OSGILauncher();
        }
        return new ServiceLauncher();
    }

    public static synchronized void shutdown() {
        if (launcher != null) {
            launcher.shutdown();
            launcher = null;
            platform = null;
        }
    }

    @Deprecated
    public static synchronized void initialize(PlatformConfig config) {
        try {
            Platform.startup(config);
        }
        catch (BirtException ex) {
            log.log(Level.SEVERE, ex.getMessage());
        }
    }

    public static void setPlatform(IPlatform platform) {
        Platform.platform = platform;
    }

    public static IExtensionRegistry getExtensionRegistry() {
        if (platform != null) {
            return platform.getExtensionRegistry();
        }
        return null;
    }

    public static IAdapterManager getAdapterManager() {
        if (platform != null) {
            return platform.getAdapterManager();
        }
        return null;
    }

    @Deprecated
    public static IBundle getBundle(String symbolicName) {
        if (platform != null) {
            return platform.getBundle(symbolicName);
        }
        return null;
    }

    @Deprecated
    public static URL find(IBundle bundle, IPlatformPath path) {
        if (platform != null) {
            return platform.find(bundle, path);
        }
        return null;
    }

    @Deprecated
    public static int getPlatformType() {
        return platformType;
    }

    @Deprecated
    public static URL asLocalURL(URL url) throws IOException {
        if (platform != null) {
            return platform.asLocalURL(url);
        }
        return null;
    }

    @Deprecated
    public static boolean runningEclipse() {
        return platform != null;
    }

    public static void intializeTracing(String pluginName) {
        if (platform != null) {
            platform.initializeTracing(pluginName);
        }
    }

    @Deprecated
    public static String getDebugOption(String name) {
        if (platform != null) {
            return platform.getDebugOption(name);
        }
        return null;
    }

    public static Object createFactoryObject(String extensionId) {
        if (platform != null) {
            return platform.createFactoryObject(extensionId);
        }
        return null;
    }

    public static Object enterPlatformContext() {
        if (platform != null) {
            return platform.enterPlatformContext();
        }
        return null;
    }

    public static void exitPlatformContext(Object context) {
        if (platform != null) {
            platform.exitPlatformContext(context);
        }
    }

    public static String getOS() {
        if (platform != null) {
            return platform.getOS();
        }
        return "unknown";
    }

    public static String getStateLocation(String symbolicName) {
        IBundle bundle;
        if (platform != null && (bundle = platform.getBundle(symbolicName)) != null) {
            return bundle.getStateLocation();
        }
        return null;
    }

    public static URL getEntry(String symbolicName, String resource) {
        IBundle bundle;
        if (platform != null && (bundle = platform.getBundle(symbolicName)) != null) {
            return bundle.getEntry(resource);
        }
        return null;
    }
}

