/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.util.ArrayList;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.calculator.ICalculator;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrException;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.Finance;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMirr
extends AggrFunction {
    @Override
    public String getName() {
        return "MIRR";
    }

    @Override
    public int getType() {
        return 0;
    }

    @Override
    public int getDataType() {
        return 3;
    }

    @Override
    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("finance rate", Messages.getString("TotalMirr.param.finance_rate"), false, false, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("reinvestment rate", Messages.getString("TotalMirr.param.reinvestment_rate"), false, false, SupportedDataTypes.CALCULATABLE, "")};
    }

    @Override
    public Accumulator newAccumulator() {
        return new MyAccumulator(CalculatorFactory.getCalculator(this.getDataType()));
    }

    @Override
    public String getDescription() {
        return Messages.getString("TotalMirr.description");
    }

    @Override
    public String getDisplayName() {
        return Messages.getString("TotalMirr.displayName");
    }

    private static class MyAccumulator
    extends SummaryAccumulator {
        private ArrayList<Number> list;
        private double frate = 0.0;
        private double rrate = 0.0;
        private Number ret = null;

        MyAccumulator(ICalculator calc) {
            super(calc);
        }

        @Override
        public void start() {
            super.start();
            this.frate = 0.0;
            this.rrate = 0.0;
            this.list = new ArrayList();
            this.ret = null;
        }

        @Override
        public void onRow(Object[] args) throws DataException {
            assert (args.length > 2);
            if (args[0] != null) {
                try {
                    if (this.list.size() == 0) {
                        if (args[1] != null) {
                            this.frate = DataTypeUtil.toDouble(args[1]);
                        }
                        if (args[2] != null) {
                            this.rrate = DataTypeUtil.toDouble(args[2]);
                        }
                    }
                    this.list.add(this.calculator.add(this.calculator.getTypedObject(0), this.calculator.getTypedObject(args[0])));
                }
                catch (BirtException e) {
                    throw DataException.wrap(new AggrException("aggregation.DataConversionError", e));
                }
            }
        }

        @Override
        public void finish() throws DataException {
            if (this.frate < 0.0 || this.rrate < 0.0) {
                throw DataException.wrap(new AggrException("aggregation.BadAggrFuncParam", "mirr"));
            }
            if (this.list.size() > 0) {
                Object[] values = new Number[this.list.size()];
                this.list.toArray(values);
                try {
                    this.ret = new Double(Finance.mirr(values, this.frate, this.rrate));
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
            super.finish();
        }

        @Override
        public Object getSummaryValue() {
            return this.ret;
        }
    }
}

