/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ICompiledScript;
import org.eclipse.birt.core.script.JavascriptEvalUtil;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.core.script.ScriptExpression;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompareHints;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.eclipse.birt.data.engine.script.NEvaluator;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class ExprEvaluateUtil {
    public static Object evaluateExpression(IBaseExpression dataExpr, IResultIterator odiResult, Scriptable scope, ScriptContext cx) throws BirtException {
        Object exprValue = null;
        if (dataExpr == null) {
            throw new DataException("data.engine.BadDataExpression");
        }
        Object handle = dataExpr.getHandle();
        if (handle instanceof ICompiledScript) {
            return cx.newContext(scope).evaluate((ICompiledScript)handle);
        }
        if (handle instanceof CompiledExpression) {
            CompiledExpression expr = (CompiledExpression)handle;
            Object value = ExprEvaluateUtil.evaluateCompiledExpression(expr, odiResult, scope, cx);
            try {
                if (value instanceof BirtException) {
                    throw (BirtException)value;
                }
                exprValue = DataTypeUtil.convert(value, dataExpr.getDataType());
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        } else if (handle instanceof ConditionalExpression) {
            ConditionalExpression ce = (ConditionalExpression)handle;
            Object resultExpr = ExprEvaluateUtil.evaluateExpression(ce.getExpression(), odiResult, scope, cx);
            Object[] op1Value = new Object[]{};
            Object[] op2Value = new Object[]{};
            boolean isCombined = false;
            if (ce.getOperand1() != null) {
                if (ce.getOperand1() instanceof IScriptExpression) {
                    op1Value = new Object[]{ExprEvaluateUtil.evaluateExpression(ce.getOperand1(), odiResult, scope, cx)};
                } else if (ce.getOperand1() instanceof IExpressionCollection) {
                    isCombined = true;
                    Object[] exprs = ((IExpressionCollection)ce.getOperand1()).getExpressions().toArray();
                    int length = exprs.length;
                    Object[] result = new Object[length];
                    int i = 0;
                    while (i < length) {
                        result[i] = ExprEvaluateUtil.evaluateExpression((IBaseExpression)exprs[i], odiResult, scope, cx);
                        ++i;
                    }
                    op1Value = ExprEvaluateUtil.flatternMultipleValues(result);
                }
            }
            if (ce.getOperand2() != null && ce.getOperand2() instanceof IScriptExpression) {
                op2Value = new Object[]{ExprEvaluateUtil.evaluateExpression(ce.getOperand2(), odiResult, scope, cx)};
            }
            exprValue = isCombined ? ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value) : ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value.length > 0 ? op1Value[0] : null, op2Value.length > 0 ? op2Value[0] : null);
        } else {
            if ("constant".equals(dataExpr.getScriptId())) {
                Object value = ((IScriptExpression)dataExpr).getHandle();
                if (value == null) {
                    value = ((IScriptExpression)dataExpr).getText();
                    ((IScriptExpression)dataExpr).setHandle(value);
                }
                exprValue = DataTypeUtil.convert(value, dataExpr.getDataType());
                return exprValue;
            }
            DataException e = new DataException("data.engine.InvalidExprHandle");
            throw e;
        }
        return exprValue;
    }

    public static Object evaluateCompiledExpression(CompiledExpression expr, IResultObject ro, int currentIndex, Scriptable scope, ScriptContext cx) throws DataException {
        if (expr instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression colref = (ColumnReferenceExpression)expr;
            if (colref.isIndexed()) {
                int idx = colref.getColumnindex();
                if (idx == 0) {
                    return currentIndex;
                }
                if (ro != null) {
                    try {
                        return DataTypeUtil.convert(ro.getFieldValue(idx), colref.getDataType());
                    }
                    catch (BirtException e) {
                        throw DataException.wrap(e);
                    }
                }
                return null;
            }
            String name = colref.getColumnName();
            if ("_rowPosition".equals(name)) {
                return currentIndex;
            }
            if (ro != null) {
                try {
                    return DataTypeUtil.convert(ro.getFieldValue(name), colref.getDataType());
                }
                catch (BirtException e) {
                    throw DataException.wrap(e);
                }
            }
            return null;
        }
        return expr.evaluate(cx, scope);
    }

    public static Object evaluateCompiledExpression(CompiledExpression expr, IResultIterator odiResult, Scriptable scope, ScriptContext cx) throws DataException {
        return ExprEvaluateUtil.evaluateCompiledExpression(expr, odiResult.getCurrentResult(), odiResult.getCurrentResultIndex(), scope, cx);
    }

    public static Object evaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, ScriptContext cx) throws BirtException {
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, false, cx);
    }

    public static Object evaluateRawExpression2(IBaseExpression dataExpr, Scriptable scope, ScriptContext cx, DataSetRuntime dataSet) throws BirtException {
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, true, cx, dataSet);
    }

    protected static Object doEvaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx) throws BirtException {
        if (dataExpr == null) {
            return null;
        }
        if (dataExpr instanceof IScriptExpression) {
            if (((IScriptExpression)dataExpr).getText() == null && !"constant".equals(dataExpr.getScriptId())) {
                throw new DataException("data.engine.EmptyExpression");
            }
            Object value = null;
            if ("constant".equals(dataExpr.getScriptId())) {
                value = ((IScriptExpression)dataExpr).getHandle();
                if (value == null) {
                    value = ((IScriptExpression)dataExpr).getText();
                    ((IScriptExpression)dataExpr).setHandle(value);
                }
            } else {
                value = ScriptEvalUtil.evaluateJSAsExpr(cx, scope, ((IScriptExpression)dataExpr).getText(), ScriptExpression.defaultID, 0);
            }
            if (javaType) {
                value = JavascriptEvalUtil.convertJavascriptValue(value);
            }
            value = DataTypeUtil.convert(value, dataExpr.getDataType());
            return value;
        }
        if (dataExpr instanceof IConditionalExpression) {
            return ExprEvaluateUtil.evaluateConditionExpression((IConditionalExpression)dataExpr, scope, javaType, cx, null);
        }
        assert (false);
        return null;
    }

    private static String extractDirectColumn(IBaseExpression dataExpr, ScriptContext cx, boolean isRow) throws BirtException {
        if (dataExpr instanceof IScriptExpression) {
            String exprText = ((IScriptExpression)dataExpr).getText();
            if (isRow) {
                return ExpressionUtil.getColumnBindingName(exprText);
            }
            return ExpressionUtil.getColumnName(exprText);
        }
        return null;
    }

    private static Object doEvaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx, DataSetRuntime dataSet) throws BirtException {
        if (dataSet == null) {
            return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, javaType, cx);
        }
        String dataSetColumn = ExprEvaluateUtil.extractDirectColumn(dataExpr, cx, false);
        if (dataSetColumn != null && dataSet.getCurrentRow() != null && dataSet.getCurrentRow().getResultClass().getFieldIndex(dataSetColumn) >= 0) {
            Object value = dataSet.getCurrentRow().getFieldValue(dataSetColumn);
            return DataTypeUtil.convert(value, dataExpr.getDataType());
        }
        String rowName = ExprEvaluateUtil.extractDirectColumn(dataExpr, cx, true);
        if (rowName != null) {
            Scriptable scriptable = dataSet.getJSResultRowObject();
            if (scriptable instanceof JSResultSetRow) {
                IBaseExpression expr;
                JSResultSetRow resultSetRow = (JSResultSetRow)scriptable;
                IBinding b = resultSetRow.getBinding(rowName);
                if (b != null && b.getAggrFunction() == null && (dataSetColumn = ExprEvaluateUtil.extractDirectColumn(expr = b.getExpression(), cx, false)) != null && dataSet.getCurrentRow() != null && dataSet.getCurrentRow().getResultClass().getFieldIndex(dataSetColumn) >= 0) {
                    Object value = dataSet.getCurrentRow().getFieldValue(dataSetColumn);
                    return DataTypeUtil.convert(value, b.getDataType());
                }
            } else if (dataSet.getCurrentRow() != null && dataSet.getCurrentRow().getResultClass().getFieldIndex(rowName) >= 0) {
                Object value = dataSet.getCurrentRow().getFieldValue(rowName);
                return DataTypeUtil.convert(value, dataExpr.getDataType());
            }
        }
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, javaType, cx);
    }

    public static Object evaluateConditionExpression(IConditionalExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx, CompareHints filterHints) throws DataException, BirtException {
        if (dataExpr.getHandle() != null) {
            return ((NEvaluator)dataExpr.getHandle()).evaluate(cx, scope, null);
        }
        IScriptExpression opr = dataExpr.getExpression();
        int oper = dataExpr.getOperator();
        IBaseExpression operand1 = dataExpr.getOperand1();
        IBaseExpression operand2 = dataExpr.getOperand2();
        if (operand1 instanceof IExpressionCollection) {
            Object[] expr = ((IExpressionCollection)operand1).getExpressions().toArray();
            Object[] result = new Object[expr.length];
            int i = 0;
            while (i < result.length) {
                result[i] = ExprEvaluateUtil.doEvaluateRawExpression((IBaseExpression)expr[i], scope, javaType, cx);
                ++i;
            }
            return ScriptEvalUtil.evalConditionalExpr(ExprEvaluateUtil.doEvaluateRawExpression(opr, scope, javaType, cx), oper, ExprEvaluateUtil.flatternMultipleValues(result), filterHints);
        }
        return ScriptEvalUtil.evalConditionalExpr(ExprEvaluateUtil.doEvaluateRawExpression(opr, scope, javaType, cx), oper, ExprEvaluateUtil.doEvaluateRawExpression(operand1, scope, javaType, cx), ExprEvaluateUtil.doEvaluateRawExpression(operand2, scope, javaType, cx), filterHints);
    }

    public static Object evaluateConditionExpression(IConditionalExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx, CompareHints filterHints, DataSetRuntime dataSet) throws DataException, BirtException {
        if (dataExpr.getHandle() != null) {
            return ((NEvaluator)dataExpr.getHandle()).evaluate(cx, scope, dataSet);
        }
        IScriptExpression opr = dataExpr.getExpression();
        int oper = dataExpr.getOperator();
        IBaseExpression operand1 = dataExpr.getOperand1();
        IBaseExpression operand2 = dataExpr.getOperand2();
        if (operand1 instanceof IExpressionCollection) {
            Object[] expr = ((IExpressionCollection)operand1).getExpressions().toArray();
            Object[] result = new Object[expr.length];
            int i = 0;
            while (i < result.length) {
                result[i] = ExprEvaluateUtil.doEvaluateRawExpression((IBaseExpression)expr[i], scope, javaType, cx, dataSet);
                ++i;
            }
            return ScriptEvalUtil.evalConditionalExpr(ExprEvaluateUtil.doEvaluateRawExpression(opr, scope, javaType, cx, dataSet), oper, ExprEvaluateUtil.flatternMultipleValues(result), filterHints);
        }
        return ScriptEvalUtil.evalConditionalExpr(ExprEvaluateUtil.doEvaluateRawExpression(opr, scope, javaType, cx, dataSet), oper, ExprEvaluateUtil.doEvaluateRawExpression(operand1, scope, javaType, cx, dataSet), ExprEvaluateUtil.doEvaluateRawExpression(operand2, scope, javaType, cx, dataSet), filterHints);
    }

    public static Object evaluateValue(IBaseExpression dataExpr, int index, IResultObject roObject, Scriptable scope, ScriptContext cx) throws BirtException {
        Object handle;
        Object exprValue = null;
        Object object = handle = dataExpr == null ? null : dataExpr.getHandle();
        if (handle instanceof ICompiledScript) {
            return cx.newContext(scope).evaluate((ICompiledScript)handle);
        }
        if (handle instanceof CompiledExpression) {
            CompiledExpression expr = (CompiledExpression)handle;
            Object value = ExprEvaluateUtil.evaluateCompiledExpression(expr, index, roObject, scope, cx);
            try {
                exprValue = DataTypeUtil.convert(value, dataExpr.getDataType());
            }
            catch (BirtException e) {
                throw new DataException("data.engine.InconvertibleDatatype", new Object[]{value, value.getClass(), DataType.getClass(dataExpr.getDataType())});
            }
        } else if (dataExpr instanceof ConditionalExpression) {
            int i;
            Object[] result;
            int length;
            Object[] exprs;
            ConditionalExpression ce = (ConditionalExpression)dataExpr;
            Object resultExpr = ExprEvaluateUtil.evaluateValue(ce.getExpression(), index, roObject, scope, cx);
            Object[] op1Value = new Object[]{};
            Object[] op2Value = new Object[]{};
            boolean isCombined = false;
            if (ce.getOperand1() != null) {
                if (ce.getOperand1() instanceof IScriptExpression) {
                    op1Value = new Object[]{ExprEvaluateUtil.evaluateValue(ce.getOperand1(), index, roObject, scope, cx)};
                } else if (ce.getOperand1() instanceof IExpressionCollection) {
                    isCombined = true;
                    exprs = ((IExpressionCollection)ce.getOperand1()).getExpressions().toArray();
                    length = exprs.length;
                    result = new Object[length];
                    i = 0;
                    while (i < length) {
                        result[i] = ExprEvaluateUtil.evaluateValue((IBaseExpression)exprs[i], index, roObject, scope, cx);
                        ++i;
                    }
                    op1Value = ExprEvaluateUtil.flatternMultipleValues(result);
                }
            }
            if (ce.getOperand2() != null) {
                if (ce.getOperand2() instanceof IScriptExpression) {
                    op2Value = new Object[]{ExprEvaluateUtil.evaluateValue(ce.getOperand2(), index, roObject, scope, cx)};
                } else if (ce.getOperand2() instanceof IExpressionCollection) {
                    exprs = ((IExpressionCollection)ce.getOperand2()).getExpressions().toArray();
                    length = exprs.length;
                    result = new Object[length];
                    i = 0;
                    while (i < length) {
                        result[i] = ExprEvaluateUtil.evaluateValue((IBaseExpression)exprs[i], index, roObject, scope, cx);
                        ++i;
                    }
                    op2Value = ExprEvaluateUtil.flatternMultipleValues(result);
                }
            }
            exprValue = isCombined ? ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value) : ScriptEvalUtil.evalConditionalExpr(resultExpr, ce.getOperator(), op1Value.length > 0 ? op1Value[0] : null, op2Value.length > 0 ? op2Value[0] : null);
        } else {
            DataException e = new DataException("data.engine.InvalidExprHandle");
            throw e;
        }
        return exprValue;
    }

    private static Object evaluateCompiledExpression(CompiledExpression expr, int index, IResultObject roObject, Scriptable scope, ScriptContext cx) throws DataException {
        if (expr instanceof ColumnReferenceExpression) {
            ColumnReferenceExpression colref = (ColumnReferenceExpression)expr;
            return ExprEvaluateUtil.evaluateColumnReferenceExpression(roObject, index, colref);
        }
        return expr.evaluate(cx, scope);
    }

    public static Object evaluateColumnReferenceExpression(IResultObject roObject, int index, ColumnReferenceExpression colref) throws DataException {
        if (colref.isIndexed()) {
            int idx = colref.getColumnindex();
            if (idx == 0) {
                return index;
            }
            if (roObject != null) {
                return roObject.getFieldValue(idx);
            }
            return null;
        }
        String name = colref.getColumnName();
        if ("_rowPosition".equals(name)) {
            return index;
        }
        if (roObject != null) {
            return roObject.getFieldValue(name);
        }
        return null;
    }

    public static Object[] flatternMultipleValues(Object[] values) {
        if (values == null || values.length == 0) {
            return new Object[0];
        }
        ArrayList<Object> flattern = new ArrayList<Object>();
        int i = 0;
        while (i < values.length) {
            if (values[i] instanceof Object[]) {
                Object[] flatternObj = (Object[])values[i];
                flattern.addAll(Arrays.asList(ExprEvaluateUtil.flatternMultipleValues(flatternObj)));
            } else {
                flattern.add(values[i]);
            }
            ++i;
        }
        return flattern.toArray();
    }
}

