/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.expression;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.data.ExpressionHelper;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IExpressionCollection;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ColumnReferenceExpression;
import org.eclipse.birt.data.engine.expression.CompareHints;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExprEvaluateUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.eclipse.birt.data.engine.script.NEvaluator;
import org.eclipse.birt.data.engine.script.ScriptEvalUtil;
import org.mozilla.javascript.Scriptable;

public class ExprEvaluator {
    private ExpressionHelper exprHelper = new ExpressionHelper();

    public void close() {
        this.exprHelper.close();
    }

    public Object evaluateExpression(IBaseExpression dataExpr, IResultIterator odiResult, Scriptable scope, ScriptContext cx) throws BirtException {
        return ExprEvaluateUtil.evaluateExpression(dataExpr, odiResult, scope, cx);
    }

    public Object evaluateCompiledExpression(CompiledExpression expr, IResultObject ro, int currentIndex, Scriptable scope, ScriptContext cx) throws DataException {
        return ExprEvaluateUtil.evaluateCompiledExpression(expr, ro, currentIndex, scope, cx);
    }

    public Object evaluateCompiledExpression(CompiledExpression expr, IResultIterator odiResult, Scriptable scope, ScriptContext cx) throws DataException {
        return ExprEvaluateUtil.evaluateCompiledExpression(expr, odiResult, scope, cx);
    }

    public Object evaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, ScriptContext cx) throws BirtException {
        return ExprEvaluateUtil.evaluateRawExpression(dataExpr, scope, cx);
    }

    public Object evaluateRawExpression2(IBaseExpression dataExpr, Scriptable scope, ScriptContext cx, DataSetRuntime dataSet) throws BirtException {
        return this.doEvaluateRawExpression(dataExpr, scope, true, cx, dataSet);
    }

    private Object doEvaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx) throws BirtException {
        return ExprEvaluateUtil.doEvaluateRawExpression(dataExpr, scope, javaType, cx);
    }

    private String extractDirectColumn(IBaseExpression dataExpr, ScriptContext cx, boolean isRow) throws BirtException {
        if (dataExpr instanceof IScriptExpression && !"constant".equals(dataExpr.getScriptId())) {
            String exprText = ((IScriptExpression)dataExpr).getText();
            if (isRow) {
                return this.exprHelper.getColumnBindingName(exprText);
            }
            return this.exprHelper.getColumnName(exprText);
        }
        return null;
    }

    private Object doEvaluateRawExpression(IBaseExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx, DataSetRuntime dataSet) throws BirtException {
        if (dataSet == null) {
            return this.doEvaluateRawExpression(dataExpr, scope, javaType, cx);
        }
        String dataSetColumn = this.extractDirectColumn(dataExpr, cx, false);
        if (dataSetColumn != null && dataSet.getCurrentRow() != null && dataSet.getCurrentRow().getResultClass().getFieldIndex(dataSetColumn) >= 0) {
            Object value = dataSet.getCurrentRow().getFieldValue(dataSetColumn);
            return DataTypeUtil.convert(value, dataExpr.getDataType());
        }
        String rowName = this.extractDirectColumn(dataExpr, cx, true);
        if (rowName != null) {
            Scriptable scriptable = dataSet.getJSResultRowObject();
            if (scriptable instanceof JSResultSetRow) {
                IBaseExpression expr;
                JSResultSetRow resultSetRow = (JSResultSetRow)scriptable;
                IBinding b = resultSetRow.getBinding(rowName);
                if (b != null && b.getAggrFunction() == null && (dataSetColumn = this.extractDirectColumn(expr = b.getExpression(), cx, false)) != null && dataSet.getCurrentRow() != null && dataSet.getCurrentRow().getResultClass().getFieldIndex(dataSetColumn) >= 0) {
                    Object value = dataSet.getCurrentRow().getFieldValue(dataSetColumn);
                    return DataTypeUtil.convert(value, b.getDataType());
                }
            } else if (dataSet.getCurrentRow() != null && dataSet.getCurrentRow().getResultClass().getFieldIndex(rowName) >= 0) {
                Object value = dataSet.getCurrentRow().getFieldValue(rowName);
                return DataTypeUtil.convert(value, dataExpr.getDataType());
            }
        }
        return this.doEvaluateRawExpression(dataExpr, scope, javaType, cx);
    }

    public Object evaluateConditionExpression(IConditionalExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx, CompareHints filterHints) throws DataException, BirtException {
        return ExprEvaluateUtil.evaluateConditionExpression(dataExpr, scope, javaType, cx, filterHints);
    }

    public Object evaluateConditionExpression(IConditionalExpression dataExpr, Scriptable scope, boolean javaType, ScriptContext cx, CompareHints filterHints, DataSetRuntime dataSet) throws DataException, BirtException {
        if (dataExpr.getHandle() != null) {
            return ((NEvaluator)dataExpr.getHandle()).evaluate(cx, scope, dataSet);
        }
        IScriptExpression opr = dataExpr.getExpression();
        int oper = dataExpr.getOperator();
        IBaseExpression operand1 = dataExpr.getOperand1();
        IBaseExpression operand2 = dataExpr.getOperand2();
        if (operand1 instanceof IExpressionCollection) {
            Object[] expr = ((IExpressionCollection)operand1).getExpressions().toArray();
            Object[] result = new Object[expr.length];
            int i = 0;
            while (i < result.length) {
                result[i] = this.doEvaluateRawExpression((IBaseExpression)expr[i], scope, javaType, cx, dataSet);
                ++i;
            }
            return ScriptEvalUtil.evalConditionalExpr(this.doEvaluateRawExpression(opr, scope, javaType, cx, dataSet), oper, ExprEvaluateUtil.flatternMultipleValues(result), filterHints);
        }
        return ScriptEvalUtil.evalConditionalExpr(this.doEvaluateRawExpression(opr, scope, javaType, cx, dataSet), oper, this.doEvaluateRawExpression(operand1, scope, javaType, cx, dataSet), this.doEvaluateRawExpression(operand2, scope, javaType, cx, dataSet), filterHints);
    }

    public Object evaluateValue(IBaseExpression dataExpr, int index, IResultObject roObject, Scriptable scope, ScriptContext cx) throws BirtException {
        return ExprEvaluateUtil.evaluateValue(dataExpr, index, roObject, scope, cx);
    }

    public Object evaluateColumnReferenceExpression(IResultObject roObject, int index, ColumnReferenceExpression colref) throws DataException {
        return ExprEvaluateUtil.evaluateColumnReferenceExpression(roObject, index, colref);
    }
}

