/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.cursor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.olap.OLAPException;
import org.eclipse.birt.data.engine.olap.cursor.MemberTreeNode;
import org.eclipse.birt.data.engine.olap.cursor.MirrorMetaInfo;
import org.eclipse.birt.data.engine.olap.cursor.TimeMemberUtil;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.AggregationDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.AggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.AggrSortDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.util.sort.DimensionSortEvalHelper;

public class MirroredAggregationResultSet
implements IAggregationResultSet {
    private IAggregationResultSet rs = null;
    private int mirrorLevel;
    private int length = 0;
    private int position = -1;
    private int nodeLength;
    private int valueMapLength;
    private long predictLength = 0L;
    private boolean breakHierarchy = false;
    private Object[] resultObject;
    private MemberTreeNode rootNode;
    private List sortList;
    private List[] breakHierarchyList;
    private Map valueMap;
    private boolean isTimeMirror = false;
    private MirrorMetaInfo service;

    public MirroredAggregationResultSet(IAggregationResultSet rs, MirrorMetaInfo service, List sortList) throws IOException, OLAPException {
        this.mirrorLevel = service.getMirrorStartPosition();
        this.breakHierarchy = service.isBreakHierarchy();
        this.service = service;
        Member member = new Member();
        member.setKeyValues(new Object[]{"#ROOT#"});
        this.rootNode = new MemberTreeNode(member);
        this.resultObject = new Object[rs.getLevelCount()];
        this.rs = rs;
        this.sortList = sortList;
        this.isTimeMirror = TimeMemberUtil.containsTimeMirror(rs, service);
        if (!this.isTimeMirror && this.breakHierarchy) {
            this.breakHierarchyList = new ArrayList[rs.getLevelCount() - this.mirrorLevel];
            int j = 0;
            while (j < this.breakHierarchyList.length) {
                this.breakHierarchyList[j] = new ArrayList();
                ++j;
            }
            this.populateMirror();
        } else {
            if (!this.isTimeMirror && !this.breakHierarchy) {
                --this.mirrorLevel;
            }
            this.populateTimeMirror();
            this.nodeLength = this.getLength(this.rootNode);
            this.valueMapLength = 0;
            Iterator iter = this.valueMap.entrySet().iterator();
            while (iter.hasNext()) {
                this.valueMapLength += this.getLength((MemberTreeNode)iter.next().getValue());
            }
            this.length = this.nodeLength * this.valueMapLength;
        }
    }

    private int findAggregationSort(int levelIndex) {
        int sortType = -1;
        if (this.sortList != null) {
            DimLevel level = this.rs.getLevel(levelIndex);
            int i = 0;
            while (i < this.sortList.size()) {
                DimensionSortEvalHelper dimSort;
                if (this.sortList.get(i) instanceof AggrSortDefinition) {
                    AggrSortDefinition defn = (AggrSortDefinition)this.sortList.get(i);
                    if (level.equals(defn.getTargetLevel())) {
                        sortType = defn.getAxisQualifierLevel().length == 0 ? defn.getSortDirection() : -1;
                        return sortType;
                    }
                } else if (this.sortList.get(i) instanceof DimensionSortEvalHelper && (dimSort = (DimensionSortEvalHelper)this.sortList.get(i)).getTargetLevel().equals(level)) {
                    return -1;
                }
                ++i;
            }
        }
        if ((sortType = this.rs.getSortType(levelIndex)) == -1) {
            sortType = 0;
        }
        return sortType;
    }

    private void populateTimeMirror() throws IOException {
        int k;
        Object[] preValue = new Object[this.rs.getLevelCount()];
        Object[] currValue = new Object[this.rs.getLevelCount()];
        final int sortType = this.getSortTypeOnMirroredLevel(this.mirrorLevel);
        this.valueMap = sortType != -1 ? new TreeMap(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                if (sortType == 0) {
                    return ((Comparable)arg0).compareTo(arg1);
                }
                return ((Comparable)arg0).compareTo(arg1) * -1;
            }
        }) : new HashMap();
        int i = 0;
        while (i < this.rs.length()) {
            this.rs.seek(i);
            MemberTreeNode parent = this.rootNode;
            int j = 0;
            while (j < this.rs.getLevelCount()) {
                currValue[j] = this.rs.getLevelKeyValue(j) != null ? this.rs.getLevelKeyValue(j)[0] : null;
                ++j;
            }
            j = 0;
            while (j < this.mirrorLevel) {
                if (!this.isEqualObject(preValue[j], currValue[j])) {
                    member = new Member();
                    member.setKeyValues(new Object[]{currValue[j]});
                    member.setAttributes(this.rs.getLevelAttributesValue(j));
                    child = new MemberTreeNode(member);
                    parent.insertNode(child);
                    child.parentNode = parent;
                    parent = child;
                } else if (parent.childNodesList.size() > 0) {
                    parent = parent.childNodesList.get(parent.childNodesList.size() - 1);
                } else {
                    member = new Member();
                    member.setKeyValues(new Object[]{currValue[j]});
                    member.setAttributes(this.rs.getLevelAttributesValue(j));
                    child = new MemberTreeNode(member);
                    parent.insertNode(child);
                    child.parentNode = parent;
                    parent = child;
                }
                ++j;
            }
            Member mirrorMember = new Member();
            mirrorMember.setKeyValues(new Object[]{currValue[this.mirrorLevel]});
            mirrorMember.setAttributes(this.rs.getLevelAttributesValue(this.mirrorLevel));
            if (this.valueMap.containsKey(mirrorMember)) {
                MemberTreeNode node = (MemberTreeNode)this.valueMap.get(mirrorMember);
                j = this.mirrorLevel + 1;
                while (j < this.rs.getLevelCount()) {
                    member = new Member();
                    member.setKeyValues(new Object[]{currValue[j]});
                    member.setAttributes(this.rs.getLevelAttributesValue(j));
                    if (!node.containsChild(member)) {
                        if (TimeMemberUtil.isTimeMirror(this.rs, j, this.service)) {
                            MemberTreeNode[] nodes = TimeMemberUtil.getDateTimeNodes(this.rs.getAllLevels(), this.rs.getLevelAttribute(j, 0), j, this.service);
                            int k2 = 0;
                            while (k2 < nodes.length) {
                                node.insertNode(nodes[k2]);
                                nodes[k2].parentNode = node;
                                ++k2;
                            }
                            break;
                        }
                        MemberTreeNode childNode = new MemberTreeNode(member);
                        node.insertNode(childNode);
                        childNode.parentNode = node;
                        node = childNode;
                    } else {
                        node = node.getChild(member);
                    }
                    ++j;
                }
            } else {
                MemberTreeNode parentNode = null;
                j = this.mirrorLevel;
                while (j < this.rs.getLevelCount()) {
                    if (TimeMemberUtil.isTimeMirror(this.rs, j, this.service)) {
                        MemberTreeNode[] nodes = TimeMemberUtil.getDateTimeNodes(this.rs.getAllLevels(), this.rs.getLevelAttribute(j, 0), j, this.service);
                        int k3 = 0;
                        while (k3 < nodes.length) {
                            if (parentNode == null) {
                                this.valueMap.put(nodes[k3].key, nodes[k3]);
                            } else {
                                parentNode.insertNode(nodes[k3]);
                            }
                            nodes[k3].parentNode = parentNode;
                            ++k3;
                        }
                        break;
                    }
                    if (parentNode == null) {
                        member = new Member();
                        member.setKeyValues(new Object[]{currValue[j]});
                        member.setAttributes(this.rs.getLevelAttributesValue(j));
                        parentNode = new MemberTreeNode(member);
                        this.valueMap.put(mirrorMember, parentNode);
                    } else {
                        member = new Member();
                        member.setKeyValues(new Object[]{currValue[j]});
                        member.setAttributes(this.rs.getLevelAttributesValue(j));
                        MemberTreeNode childNode = new MemberTreeNode(member);
                        parentNode.insertNode(childNode);
                        childNode.parentNode = parentNode;
                        parentNode = childNode;
                    }
                    ++j;
                }
            }
            k = 0;
            while (k < this.rs.getLevelCount()) {
                preValue[k] = currValue[k];
                ++k;
            }
            ++i;
        }
        int level = this.mirrorLevel + 1;
        ArrayList nodeList1 = new ArrayList(this.valueMap.values());
        k = this.mirrorLevel + 1;
        while (k < this.rs.getLevelCount()) {
            final int childSortType = this.getSortTypeOnMirroredLevel(k);
            ArrayList<MemberTreeNode> nodeList2 = new ArrayList<MemberTreeNode>();
            if (sortType != -1) {
                while (k > level) {
                    int j = 0;
                    while (j < nodeList1.size()) {
                        nodeList2.addAll(((MemberTreeNode)nodeList1.get((int)j)).childNodesList);
                        ++j;
                    }
                    nodeList1.clear();
                    nodeList1.addAll(nodeList2);
                    nodeList2.clear();
                    ++level;
                }
                int j = 0;
                while (j < nodeList1.size()) {
                    MemberTreeNode node = (MemberTreeNode)nodeList1.get(j);
                    Collections.sort(node.childNodesList, new Comparator(){

                        public int compare(Object arg0, Object arg1) {
                            if (childSortType == 0) {
                                return ((Comparable)((MemberTreeNode)arg0).key).compareTo(((MemberTreeNode)arg1).key);
                            }
                            return ((Comparable)((MemberTreeNode)arg0).key).compareTo(((MemberTreeNode)arg1).key) * -1;
                        }
                    });
                    ++j;
                }
            }
            ++k;
        }
    }

    private void populateMirror() throws IOException, OLAPException {
        Object[] preValue = new Object[this.mirrorLevel];
        Object[] currValue = new Object[this.mirrorLevel];
        int i = 0;
        while (i < this.rs.length()) {
            this.rs.seek(i);
            MemberTreeNode parent = this.rootNode;
            int j = 0;
            while (j < this.mirrorLevel) {
                currValue[j] = this.rs.getLevelKeyValue(j)[0];
                ++j;
            }
            j = 0;
            while (j < this.mirrorLevel) {
                if (!this.isEqualObject(preValue[j], currValue[j])) {
                    member = new Member();
                    member.setKeyValues(new Object[]{currValue[j]});
                    member.setAttributes(this.rs.getLevelAttributesValue(j));
                    child = new MemberTreeNode(member);
                    parent.insertNode(child);
                    child.parentNode = parent;
                    parent = child;
                } else if (parent.childNodesList.size() > 0) {
                    parent = parent.childNodesList.get(parent.childNodesList.size() - 1);
                } else {
                    member = new Member();
                    member.setKeyValues(new Object[]{currValue[j]});
                    member.setAttributes(this.rs.getLevelAttributesValue(j));
                    child = new MemberTreeNode(member);
                    parent.insertNode(child);
                    child.parentNode = parent;
                    parent = child;
                }
                ++j;
            }
            j = 0;
            while (j < this.breakHierarchyList.length) {
                Member temp = new Member();
                temp.setKeyValues(this.rs.getLevelKeyValue(j + this.mirrorLevel));
                if (!this.breakHierarchyList[j].contains(temp)) {
                    Member member = new Member();
                    member.setKeyValues(this.rs.getLevelKeyValue(j + this.mirrorLevel));
                    member.setAttributes(this.rs.getLevelAttributesValue(j + this.mirrorLevel));
                    this.breakHierarchyList[j].add(member);
                }
                ++j;
            }
            int k = 0;
            while (k < this.mirrorLevel) {
                preValue[k] = currValue[k];
                ++k;
            }
            ++i;
        }
        this.length = this.getLength(this.rootNode);
        this.predictLength = this.length;
        int k = 0;
        while (k < this.breakHierarchyList.length) {
            final int sortType = this.getSortTypeOnMirroredLevel(k + this.mirrorLevel);
            if (sortType != -1) {
                Collections.sort(this.breakHierarchyList[k], new Comparator(){

                    public int compare(Object arg0, Object arg1) {
                        if (sortType == 0) {
                            return ((Comparable)arg0).compareTo(arg1);
                        }
                        return ((Comparable)arg0).compareTo(arg1) * -1;
                    }
                });
            }
            this.predictLength *= (long)this.breakHierarchyList[k].size();
            if (this.predictLength > Integer.MAX_VALUE) {
                throw new OLAPException("data.olap.ExceedIntegerLimit");
            }
            this.length = (int)this.predictLength;
            ++k;
        }
    }

    private int getSortTypeOnMirroredLevel(int level) {
        return this.findAggregationSort(level);
    }

    private int getLength(MemberTreeNode node) {
        int length = 0;
        if (node.childNodesList.size() == 0) {
            return ++length;
        }
        int i = 0;
        while (i < node.childNodesList.size()) {
            MemberTreeNode child = node.childNodesList.get(i);
            length += this.getLength(child);
            ++i;
        }
        return length;
    }

    private boolean isEqualObject(Object preValue, Object currentValue) {
        if (preValue == currentValue) {
            return true;
        }
        if (preValue == null || currentValue == null) {
            return false;
        }
        return preValue.equals(currentValue);
    }

    @Override
    public void clear() throws IOException {
        this.rs.clear();
    }

    @Override
    public void close() throws IOException {
        this.rs.close();
    }

    @Override
    public int getAggregationCount() {
        return this.rs.getAggregationCount();
    }

    @Override
    public int getAggregationDataType(int aggregationIndex) throws IOException {
        return this.rs.getAggregationDataType(aggregationIndex);
    }

    @Override
    public AggregationDefinition getAggregationDefinition() {
        return this.rs.getAggregationDefinition();
    }

    @Override
    public int getAggregationIndex(String name) throws IOException {
        return this.rs.getAggregationIndex(name);
    }

    @Override
    public String getAggregationName(int index) {
        return this.rs.getAggregationName(index);
    }

    @Override
    public Object getAggregationValue(int aggregationIndex) throws IOException {
        return this.rs.getAggregationValue(aggregationIndex);
    }

    @Override
    public String[][] getAttributeNames() {
        return this.rs.getAttributeNames();
    }

    @Override
    public DimLevel[] getAllLevels() {
        return this.rs.getAllLevels();
    }

    @Override
    public IAggregationResultRow getCurrentRow() throws IOException {
        Member[] member = new Member[this.resultObject.length];
        int i = 0;
        while (i < this.resultObject.length) {
            member[i] = (Member)this.resultObject[i];
            ++i;
        }
        AggregationResultRow row = new AggregationResultRow(member, null);
        return row;
    }

    @Override
    public String[][] getKeyNames() {
        return this.rs.getKeyNames();
    }

    @Override
    public DimLevel getLevel(int levelIndex) {
        return this.rs.getLevel(levelIndex);
    }

    @Override
    public Object getLevelAttribute(int levelIndex, int attributeIndex) {
        if (levelIndex < 0 || this.resultObject.length < levelIndex) {
            return null;
        }
        return ((Member)this.resultObject[levelIndex]).getAttributes()[attributeIndex];
    }

    @Override
    public int getLevelAttributeColCount(int levelIndex) {
        return this.rs.getLevelAttributeColCount(levelIndex);
    }

    @Override
    public int getLevelAttributeDataType(DimLevel level, String attributeName) {
        return this.rs.getLevelAttributeDataType(level, attributeName);
    }

    @Override
    public int getLevelAttributeDataType(int levelIndex, String attributeName) {
        return this.rs.getLevelAttributeDataType(levelIndex, attributeName);
    }

    @Override
    public int getLevelAttributeIndex(int levelIndex, String attributeName) {
        return this.rs.getLevelAttributeIndex(levelIndex, attributeName);
    }

    @Override
    public int getLevelAttributeIndex(DimLevel level, String attributeName) {
        return this.rs.getLevelAttributeIndex(level, attributeName);
    }

    @Override
    public String[] getLevelAttributes(int levelIndex) {
        return this.rs.getLevelAttributes(levelIndex);
    }

    @Override
    public int getLevelCount() {
        return this.rs.getLevelCount();
    }

    @Override
    public int getLevelIndex(DimLevel level) {
        return this.rs.getLevelIndex(level);
    }

    @Override
    public int getLevelKeyColCount(int levelIndex) {
        return this.rs.getLevelKeyColCount(levelIndex);
    }

    @Override
    public int getLevelKeyDataType(DimLevel level, String keyName) {
        return this.rs.getLevelKeyDataType(level, keyName);
    }

    @Override
    public int getLevelKeyDataType(int levelIndex, String keyName) {
        return this.rs.getLevelKeyDataType(levelIndex, keyName);
    }

    @Override
    public int getLevelKeyIndex(int levelIndex, String keyName) {
        return this.rs.getLevelKeyIndex(levelIndex, keyName);
    }

    @Override
    public int getLevelKeyIndex(DimLevel level, String keyName) {
        return this.rs.getLevelKeyIndex(level, keyName);
    }

    @Override
    public String getLevelKeyName(int levelIndex, int keyIndex) {
        return this.rs.getLevelKeyName(levelIndex, keyIndex);
    }

    @Override
    public Object[] getLevelKeyValue(int levelIndex) {
        return ((Member)this.resultObject[levelIndex]).getKeyValues();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getSortType(int levelIndex) {
        return this.rs.getSortType(levelIndex);
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public void seek(int index) throws IOException {
        block12: {
            block11: {
                this.position = index;
                if (this.isTimeMirror || !this.breakHierarchy) break block11;
                int remainder = 0;
                int mirrorPlus = 1;
                int j = 0;
                while (j < this.breakHierarchyList.length) {
                    mirrorPlus *= this.breakHierarchyList[j].size();
                    ++j;
                }
                int number = (int)Math.floor(index / mirrorPlus);
                remainder = index % mirrorPlus;
                MemberTreeNode node = this.findOuterMostChild(this.rootNode, number + 1, 0);
                int j2 = this.mirrorLevel - 1;
                while (j2 >= 0) {
                    this.resultObject[j2] = node.key;
                    node = node.parentNode;
                    --j2;
                }
                int i = this.mirrorLevel;
                while (i < this.rs.getLevelCount()) {
                    mirrorPlus = 1;
                    if (i < this.rs.getLevelCount() - 1) {
                        int j3 = i + 1;
                        while (j3 < this.rs.getLevelCount()) {
                            mirrorPlus *= this.breakHierarchyList[j3 - this.mirrorLevel].size();
                            ++j3;
                        }
                        number = (int)Math.floor((double)remainder / (double)mirrorPlus);
                    } else {
                        number = remainder;
                    }
                    this.resultObject[i] = this.breakHierarchyList[i - this.mirrorLevel].get(number);
                    remainder %= mirrorPlus;
                    ++i;
                }
                break block12;
            }
            int nodePos = (int)Math.floor((double)index / (double)this.valueMapLength);
            int remainder = index % this.valueMapLength;
            MemberTreeNode node = this.findOuterMostChild(this.rootNode, nodePos + 1, 0);
            Iterator iter = this.valueMap.entrySet().iterator();
            int currentLength = 0;
            MemberTreeNode findNode = null;
            while (iter.hasNext()) {
                MemberTreeNode n1 = (MemberTreeNode)iter.next().getValue();
                int len = this.getLength(n1);
                if (currentLength + len <= remainder) {
                    currentLength += len;
                    continue;
                }
                findNode = this.findOuterMostChild(n1, remainder - currentLength + 1, 0);
                break;
            }
            if (node != null) {
                int i = this.mirrorLevel - 1;
                while (i >= 0) {
                    this.resultObject[i] = node.key;
                    node = node.parentNode;
                    --i;
                }
            }
            if (findNode == null) break block12;
            int i = this.rs.getLevelCount() - 1;
            while (i >= this.mirrorLevel) {
                this.resultObject[i] = findNode.key;
                findNode = findNode.parentNode;
                --i;
            }
        }
    }

    private MemberTreeNode findOuterMostChild(MemberTreeNode node, int index, int startIndex) {
        int temp = startIndex;
        if (node.childNodesList.size() == 0 && index == ++temp) {
            return node;
        }
        int i = 0;
        while (i < node.childNodesList.size()) {
            MemberTreeNode child = node.childNodesList.get(i);
            MemberTreeNode find = this.findOuterMostChild(child, index, temp);
            if (find != null) {
                return find;
            }
            temp += this.getLength(child);
            ++i;
        }
        return null;
    }

    @Override
    public int[] getAggregationDataType() {
        return this.rs.getAggregationDataType();
    }

    @Override
    public int[][] getLevelAttributeDataType() {
        return this.rs.getLevelAttributeDataType();
    }

    @Override
    public String[][] getLevelAttributes() {
        return this.rs.getLevelAttributes();
    }

    @Override
    public int[][] getLevelKeyDataType() {
        return this.rs.getLevelKeyDataType();
    }

    @Override
    public String[][] getLevelKeys() {
        return this.rs.getLevelKeys();
    }

    @Override
    public int[] getSortType() {
        return this.rs.getSortType();
    }

    @Override
    public Object[] getLevelAttributesValue(int levelIndex) {
        return ((Member)this.resultObject[levelIndex]).getAttributes();
    }
}

