/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.odp.device;

import java.awt.Color;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.emitter.odp.OdpContext;
import org.eclipse.birt.report.engine.emitter.odp.OdpWriter;
import org.eclipse.birt.report.engine.emitter.odp.device.OdpPage;
import org.eclipse.birt.report.engine.emitter.odp.util.OdpUtil;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.odf.IOdfMasterPageWriter;
import org.eclipse.birt.report.engine.odf.MasterPageManager;
import org.eclipse.birt.report.engine.odf.style.StyleBuilder;
import org.eclipse.birt.report.engine.odf.style.StyleEntry;
import org.eclipse.birt.report.engine.odf.writer.MasterPageWriter;

public class OdpPageDevice
implements IPageDevice {
    private OdpWriter writer;
    private IOdfMasterPageWriter mpWriter;
    private OdpPage currentPage;
    private OdpContext context;

    public OdpPageDevice(OutputStream output, OutputStream mpOutput, OdpContext context) throws Exception {
        this.writer = new OdpWriter(output);
        this.writer.start();
        this.mpWriter = new MasterPageWriter(mpOutput);
        this.mpWriter.start();
        this.context = context;
    }

    @Override
    public void close() throws Exception {
        this.writer.end();
        this.mpWriter.end();
    }

    @Override
    public IPage newPage(int width, int height, Color backgroundColor) {
        MasterPageManager mpManager = this.context.getMasterPageManager();
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        mpManager.newPage("Standard");
        StyleEntry pageLayout = StyleBuilder.createEmptyStyleEntry(6);
        pageLayout.setProperty(35, (float)width / 1000.0f + "pt");
        pageLayout.setProperty(36, (float)height / 1000.0f + "pt");
        if (backgroundColor != null) {
            pageLayout.setProperty(6, OdpUtil.getColorString(backgroundColor));
        }
        this.context.addGlobalStyle(pageLayout);
        this.mpWriter.startMasterPage(pageLayout, mpManager.getCurrentMasterPage(), null);
        this.mpWriter.endMasterPage();
        this.currentPage = new OdpPage(width, height, backgroundColor, this.writer, this.context);
        return this.currentPage;
    }
}

