/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import java.awt.Color;
import java.util.Set;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.instance.IScriptStyle;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.openpdf.text.pdf.PdfAction;
import org.openpdf.text.pdf.PdfOutline;

public class TOCHandler {
    protected TOCNode root;
    protected PdfOutline outline;
    protected Set<String> bookmarks;
    private long counter = 0L;
    private static final long MAX_COUNT = 70000L;

    public TOCHandler(TOCNode root, PdfOutline outline, Set<String> bookmarks) {
        this.root = root;
        this.outline = outline;
        this.bookmarks = bookmarks;
    }

    @Deprecated
    public TOCNode getTOCRoot() {
        return this.root;
    }

    public void createTOC() {
        this.createTOC(this.root, this.outline, this.bookmarks);
    }

    protected void createTOC(TOCNode tocNode, PdfOutline pol, Set<String> bookmarks) {
        if (this.isOutlineSizeOverflow() || tocNode == null || tocNode.getChildren() == null) {
            return;
        }
        for (TOCNode node : tocNode.getChildren()) {
            Color awtColor;
            if (!bookmarks.contains(node.getBookmark())) {
                this.createTOC(node, this.outline, bookmarks);
                continue;
            }
            PdfOutline outline = new PdfOutline(pol, PdfAction.gotoLocalPage((String)node.getBookmark(), (boolean)false), node.getDisplayString());
            this.countOutlineSize();
            IScriptStyle style = node.getTOCStyle();
            String color = style.getColor();
            if (color != null) {
                color = color.toLowerCase();
            }
            if ((awtColor = PropertyUtil.getColor(color)) != null) {
                outline.setColor(awtColor);
            }
            String fontStyle = style.getFontStyle();
            String fontWeight = style.getFontWeight();
            int styleValue = PropertyUtil.getFontStyle(fontStyle, fontWeight);
            outline.setStyle(styleValue);
            this.createTOC(node, outline, bookmarks);
        }
    }

    protected boolean isOutlineSizeOverflow() {
        return this.counter > 70000L;
    }

    protected void countOutlineSize() {
        ++this.counter;
    }
}

