/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.content.impl.AutoTextContent;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXCanvas;
import org.eclipse.birt.report.engine.emitter.pptx.PPTXRender;
import org.eclipse.birt.report.engine.emitter.pptx.TableVisitor;
import org.eclipse.birt.report.engine.emitter.pptx.TextWriter;
import org.eclipse.birt.report.engine.emitter.pptx.util.PPTXUtil;
import org.eclipse.birt.report.engine.emitter.pptx.writer.Presentation;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.BlockTextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RowArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TableGroupArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.style.BackgroundImageInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BorderInfo;
import org.eclipse.birt.report.engine.nLayout.area.style.BoxStyle;
import org.eclipse.birt.report.engine.nLayout.area.style.DiagonalInfo;
import org.eclipse.birt.report.engine.ooxml.writer.OOXmlWriter;

public class TableWriter {
    private static final String RIGHTBORDERLINE = "a:lnR";
    private static final String LEFTBORDERLINE = "a:lnL";
    private static final String TOPBORDERLINE = "a:lnT";
    private static final String BOTTOMBORDERLINE = "a:lnB";
    private static final int DEFAULT_EMPTYCELL_FONTSIZE = 100;
    private static final int MINIMUM_ROW_HEIGHT = 4000;
    private static final int MINIMUM_COLUMN_WIDTH = 2000;
    private static final int DEFAULT_MARGIN = 12700;
    private int currentX;
    private int currentY;
    protected Stack<BoxStyle> rowStyleStack = new Stack();
    private final PPTXRender render;
    private final PPTXCanvas canvas;
    protected OOXmlWriter writer;
    private static int TableIndex = 1;
    private int numOfColumns;
    private HashMap<Integer, MergeCellDimension> rowSpanCounts;
    private int currentCol;
    private int currentRowHeight;
    private int currentRow;
    private int colspan;
    private boolean isRTL = false;
    private boolean isTextWrap = true;
    private final ArrayList<Integer> zeroColumnList = new ArrayList();
    private TextWriter emptytextboxwriter;
    private final HashMap<Integer, Integer> mapignorecolumns = new HashMap();

    public TableWriter(PPTXRender render) {
        this.render = render;
        this.canvas = render.getCanvas();
        this.writer = this.canvas.getWriter();
        this.currentX = render.getCurrentX();
        this.currentY = render.getCurrentY();
        this.isRTL = render.isRTL();
        this.isTextWrap = render.isTextWrap();
    }

    public void outputTable(TableArea table) {
        this.drawTable(table);
    }

    protected void drawTable(TableArea table) {
        String bmk;
        if (table.needClip()) {
            this.render.startClip(table);
        }
        if ((bmk = table.getBookmark()) != null) {
            Presentation presentation = this.canvas.getPresentation();
            int currentslide = presentation.getCurrentSlideIdx();
            presentation.addBookmark(bmk, currentslide);
        }
        this.currentX += this.getX(table);
        this.currentY += this.getY(table);
        this.updateRenderXY();
        this.startTable(table);
        this.parseTableExtraSpanRows(table);
        this.iterateOnRows(table);
        if (table.needClip()) {
            this.render.endclip();
        }
        this.currentX -= this.getX(table);
        this.currentY -= this.getY(table);
        this.updateRenderXY();
        this.endTable();
    }

    private void iterateOnRows(IContainerArea table) {
        int internalRowCount = this.currentRow;
        this.currentRow = 0;
        Iterator<IArea> iter = table.getChildren();
        while (iter.hasNext()) {
            IContainerArea child = (IContainerArea)iter.next();
            if (child instanceof RowArea) {
                this.drawRow((RowArea)child);
                ++this.currentRow;
                continue;
            }
            this.currentX += this.getX(child);
            this.currentY += this.getY(child);
            internalRowCount = this.currentRow;
            this.updateRenderXY();
            this.iterateOnRows(child);
            this.currentX -= this.getX(child);
            this.currentY -= this.getY(child);
            this.updateRenderXY();
            this.currentRow = internalRowCount + 1;
        }
    }

    private void parseTableExtraSpanRows(ContainerArea table) {
        int additionalrowheight = 0;
        int additionalrowspan = 0;
        boolean fistrowrun = true;
        int rowidx = table.getChildrenCount() - 1;
        while (rowidx >= 0) {
            ContainerArea child = (ContainerArea)table.getChild(rowidx);
            if (child instanceof TableGroupArea) {
                this.parseTableExtraSpanRows(child);
            } else {
                RowArea row = (RowArea)child;
                int numOfCells = row.getChildrenCount();
                if (numOfCells == 0) {
                    additionalrowheight += row.getHeight();
                    ++additionalrowspan;
                } else if (!this.zeroColumnList.isEmpty()) {
                    if (this.numOfColumns != numOfCells) {
                        Iterator<Integer> iterzero = this.zeroColumnList.iterator();
                        Iterator<IArea> itercell = row.getChildren();
                        int zerocolumn = iterzero.next();
                        while (itercell.hasNext()) {
                            CellArea cell = (CellArea)itercell.next();
                            int thiscolspan = cell.getColSpan();
                            int thiscolumn = cell.getColumnID();
                            if (thiscolspan > 1) {
                                while (iterzero.hasNext() && zerocolumn < thiscolumn) {
                                    zerocolumn = iterzero.next();
                                }
                                while (zerocolumn <= thiscolumn + thiscolspan - 1) {
                                    cell.setColSpan(--thiscolspan);
                                    if (fistrowrun) {
                                        int numOfigncol = 0;
                                        Integer numofIng = this.mapignorecolumns.get(thiscolumn);
                                        numOfigncol = numofIng == null ? 1 : numofIng + 1;
                                        this.mapignorecolumns.put(thiscolumn, numOfigncol);
                                    }
                                    if (!iterzero.hasNext()) break;
                                    zerocolumn = iterzero.next();
                                }
                                if (zerocolumn >= thiscolumn + thiscolspan) continue;
                            } else {
                                if (thiscolumn < zerocolumn) continue;
                                if (iterzero.hasNext()) {
                                    zerocolumn = iterzero.next();
                                    continue;
                                }
                            }
                            break;
                        }
                    }
                } else if (additionalrowspan > 0) {
                    row.setHeight(additionalrowheight + row.getHeight());
                    Iterator<IArea> iter = row.getChildren();
                    while (iter.hasNext()) {
                        CellArea cell = (CellArea)iter.next();
                        cell.setRowSpan(cell.getRowSpan() - additionalrowspan);
                    }
                    additionalrowheight = 0;
                    additionalrowspan = 0;
                }
            }
            --rowidx;
        }
    }

    private void startTable(TableArea tablearea) {
        int X = PPTXUtil.convertToEnums(this.currentX);
        int Y = PPTXUtil.convertToEnums(this.currentY);
        int width = this.canvas.getScaledValue(PPTXUtil.convertToEnums(tablearea.getWidth()));
        int height = this.canvas.getScaledValue(PPTXUtil.convertToEnums(tablearea.getHeight()));
        this.writer.openTag("p:graphicFrame");
        this.writer.openTag("p:nvGraphicFramePr");
        this.writer.openTag("p:cNvPr");
        this.writer.attribute("id", this.canvas.getPresentation().getNextShapeId());
        this.writer.attribute("name", "Table " + TableIndex++);
        this.writer.closeTag("p:cNvPr");
        this.writer.openTag("p:cNvGraphicFramePr");
        this.writer.openTag("a:graphicFrameLocks");
        this.writer.attribute("noGrp", "1");
        this.writer.closeTag("a:graphicFrameLocks");
        this.writer.closeTag("p:cNvGraphicFramePr");
        this.writer.openTag("p:nvPr");
        this.writer.closeTag("p:nvPr");
        this.writer.closeTag("p:nvGraphicFramePr");
        this.canvas.setPosition('p', X, Y, width, height);
        this.writer.openTag("a:graphic");
        this.writer.openTag("a:graphicData");
        this.writer.attribute("uri", "http://schemas.openxmlformats.org/drawingml/2006/table");
        this.writer.openTag("a:tbl");
        this.writer.openTag("a:tblPr");
        if (this.isRTL) {
            this.writer.attribute("rtl", 1);
        }
        this.writer.openTag("a:tableStyleId");
        this.canvas.writeText("{2D5ABB26-0587-4C30-8999-92F81FD0307C}");
        this.writer.closeTag("a:tableStyleId");
        this.writer.closeTag("a:tblPr");
        this.writeColumnsWidth(tablearea);
    }

    private void endTable() {
        this.writer.closeTag("a:tbl");
        this.writer.closeTag("a:graphicData");
        this.writer.closeTag("a:graphic");
        this.writer.closeTag("p:graphicFrame");
    }

    private void writeColumnsWidth(TableArea tablearea) {
        this.numOfColumns = tablearea.getColumnCount();
        int columnWidth = 0;
        int cellwidth = 0;
        this.writer.openTag("a:tblGrid");
        int i = 0;
        while (i < this.numOfColumns) {
            cellwidth = tablearea.getCellWidth(i, i + 1);
            if (cellwidth > 0) {
                if (cellwidth < 2000) {
                    cellwidth = 2000;
                }
                columnWidth = this.canvas.getScaledValue(PPTXUtil.convertToEnums(cellwidth));
                this.writer.openTag("a:gridCol");
                this.writer.attribute("w", columnWidth);
                this.writer.closeTag("a:gridCol");
            } else {
                this.zeroColumnList.add(i);
            }
            ++i;
        }
        this.writer.closeTag("a:tblGrid");
    }

    protected void drawRow(RowArea row) {
        if (row.getChildrenCount() == 0) {
            return;
        }
        if (row.needClip()) {
            this.render.startClip(row);
        }
        this.currentX += this.getX(row);
        this.currentY += this.getY(row);
        this.updateRenderXY();
        BoxStyle style = row.getBoxStyle();
        ContainerArea parent = row;
        while (!(parent instanceof TableArea) && style.getBackgroundColor() == null && style.getBackgroundImage() == null) {
            parent = parent.getParent();
            style = parent.getBoxStyle();
        }
        this.rowStyleStack.push(style);
        this.startRow(row);
        Iterator<IArea> iter = row.getChildren();
        this.currentCol = 0;
        int firstcellidx = ((CellArea)row.getFirstChild()).getColumnID();
        while (this.currentCol != firstcellidx) {
            int emptycol = this.currentCol;
            this.fillEmptyMergeCells(emptycol, 0, 0);
            if (emptycol != this.currentCol) continue;
            ++this.currentCol;
        }
        while (iter.hasNext()) {
            IArea child = iter.next();
            this.drawCell((CellArea)child);
        }
        this.endRow();
        this.rowStyleStack.pop();
        this.currentX -= this.getX(row);
        this.currentY -= this.getY(row);
        this.updateRenderXY();
        if (row.needClip()) {
            this.render.endclip();
        }
    }

    private void startRow(RowArea row) {
        this.writer.openTag("a:tr");
        int height = row.getSpecifiedHeight();
        if (height <= 0) {
            height = row.getHeight();
        }
        if (row.getParent() instanceof TableGroupArea) {
            height = Math.min(height, row.getParent().getHeight());
        }
        height = (height = this.canvas.getScaledValue(height)) < 4000 ? 0 : PPTXUtil.convertToEnums(height);
        this.currentRowHeight = height;
        this.writer.attribute("h", height);
    }

    private void endRow() {
        this.writer.closeTag("a:tr");
    }

    protected void drawCell(CellArea cell) {
        if (cell.getWidth() == 0) {
            ++this.currentCol;
            return;
        }
        if (cell.needClip()) {
            this.render.startClip(cell);
        }
        this.currentX += this.getX(cell);
        this.currentY += this.getY(cell);
        this.updateRenderXY();
        this.startCell(cell);
        this.visitChildren(cell);
        this.endCell(cell);
        this.currentX -= this.getX(cell);
        this.currentY -= this.getY(cell);
        this.updateRenderXY();
        if (cell.needClip()) {
            this.render.endclip();
        }
    }

    private void startCell(CellArea cell) {
        int rowspan;
        this.writer.openTag("a:tc");
        this.colspan = cell.getColSpan();
        if (this.colspan > 1) {
            this.writer.attribute("gridSpan", this.colspan);
        }
        if ((rowspan = cell.getRowSpan()) > 1) {
            int colid = cell.getColumnID();
            if (this.rowSpanCounts == null) {
                this.rowSpanCounts = new HashMap();
            }
            MergeCellDimension spancells = new MergeCellDimension(rowspan, this.colspan);
            this.rowSpanCounts.put(colid, spancells);
            this.writer.attribute("rowSpan", rowspan);
        }
    }

    private void endCell(CellArea cell) {
        this.writer.openTag("a:tcPr");
        IArea cellchild = cell.getFirstChild();
        IStyle cellstyle = cell.getContent().getComputedStyle();
        if (cellchild instanceof BlockTextArea && cell.getChildrenCount() == 1) {
            String valign;
            IStyle textboxstyle = ((BlockTextArea)cellchild).getContent().getComputedStyle();
            if (textboxstyle != null) {
                int marL = this.canvas.getScaledValue(PPTXUtil.convertCssToEnum(textboxstyle.getMarginLeft()) + PPTXUtil.convertCssToEnum(cellstyle.getPaddingLeft()));
                int marT = this.canvas.getScaledValue(PPTXUtil.convertCssToEnum(textboxstyle.getMarginTop()) + PPTXUtil.convertCssToEnum(cellstyle.getPaddingTop()));
                int marR = this.canvas.getScaledValue(PPTXUtil.convertCssToEnum(textboxstyle.getMarginRight()) + PPTXUtil.convertCssToEnum(cellstyle.getPaddingRight()));
                int marB = this.canvas.getScaledValue(PPTXUtil.convertCssToEnum(textboxstyle.getMarginBottom()) + PPTXUtil.convertCssToEnum(cellstyle.getPaddingBottom()));
                int textboxheight = this.canvas.getScaledValue(PPTXUtil.convertToEnums(cellchild.getHeight()));
                if (this.isRTL && marR <= 0) {
                    marR = 12700;
                } else if (!this.isRTL && marL <= 0) {
                    marL = 12700;
                }
                if (marT <= 0) {
                    marT = 12700;
                }
                if (marB <= 0) {
                    marB = 12700;
                }
                if (marT + textboxheight > this.currentRowHeight) {
                    marT = this.currentRowHeight - textboxheight;
                    marB = 0;
                } else if (marT + marB + textboxheight > this.currentRowHeight) {
                    marB = this.currentRowHeight - (marT + textboxheight);
                }
                this.canvas.writeMarginProperties(marT, marR, marB, marL);
            }
            if ((valign = cellstyle.getVerticalAlign()).equals("baseline") && textboxstyle != null) {
                valign = textboxstyle.getVerticalAlign();
            }
            if (valign.equals("middle")) {
                this.writer.attribute("anchor", "ctr");
            } else if (valign.equals("bottom")) {
                this.writer.attribute("anchor", "b");
            }
        } else {
            this.canvas.writeMarginProperties(0, 0, 0, 0);
        }
        this.drawCellBox(cell);
        this.writer.closeTag("a:tcPr");
        this.writer.closeTag("a:tc");
        int nxtCol = this.currentCol + 1;
        this.fillEmptyMergeCells(nxtCol, cell.getColSpan(), cell.getRowSpan());
        ++this.currentCol;
    }

    private void drawEmptyTextBox() {
        if (this.emptytextboxwriter == null) {
            this.emptytextboxwriter = new TextWriter(this.render);
        }
        this.emptytextboxwriter.writeBlankTextBlock(100);
    }

    private void fillEmptyMergeCells(int nxtCol, int icolspan, int irowspan) {
        boolean completedFill = false;
        boolean rectMerge = false;
        if (this.rowSpanCounts != null && !this.rowSpanCounts.isEmpty() && this.rowSpanCounts.containsKey(nxtCol)) {
            completedFill = true;
            MergeCellDimension mcd = this.rowSpanCounts.get(nxtCol);
            icolspan = mcd.getNumColumns();
            this.writer.openTag("a:tc");
            if (icolspan > 1) {
                this.writer.attribute("gridSpan", icolspan);
                rectMerge = true;
            }
            this.writer.attribute("vMerge", 1);
            this.writer.openTag("a:tcPr");
            this.canvas.writeMarginProperties(0, 0, 0, 0);
            this.writer.closeTag("a:tcPr");
            this.writer.closeTag("a:tc");
            mcd.removeARow();
            if (mcd.isLastRow()) {
                this.rowSpanCounts.remove(nxtCol);
            }
            ++this.currentCol;
        }
        if (icolspan > 1) {
            int emtpycell = 1;
            while (emtpycell < icolspan) {
                this.writer.openTag("a:tc");
                this.writer.attribute("hMerge", 1);
                if (irowspan > 1) {
                    this.writer.attribute("rowSpan", irowspan);
                } else if (rectMerge) {
                    this.writer.attribute("vMerge", 1);
                }
                this.writer.openTag("a:tcPr");
                this.canvas.writeMarginProperties(0, 0, 0, 0);
                this.writer.closeTag("a:tcPr");
                this.writer.closeTag("a:tc");
                ++emtpycell;
            }
            completedFill = true;
            this.currentCol = this.currentCol + icolspan - 1;
        }
        if (completedFill) {
            this.fillEmptyMergeCells(nxtCol += icolspan, 0, 0);
        }
    }

    protected void visitChildren(CellArea container) {
        Iterator<IArea> iter = container.getChildren();
        int childrencount = container.getChildrenCount();
        if (childrencount > 1 || childrencount == 0 || !(container.getFirstChild() instanceof BlockTextArea)) {
            this.drawEmptyTextBox();
        }
        while (iter.hasNext()) {
            IArea child = iter.next();
            if (child instanceof BlockTextArea && childrencount > 1) {
                this.render.visitTextBuffer((BlockTextArea)child);
                continue;
            }
            if (this.needStyleORClip(child)) {
                this.drawEmptyTextBox();
                this.render.visitTextBuffer((BlockTextArea)child);
                continue;
            }
            child.accept(this.render);
        }
    }

    private boolean needStyleORClip(IArea blocktext) {
        if (!(blocktext instanceof BlockTextArea)) {
            return false;
        }
        BlockTextArea textarea = (BlockTextArea)blocktext;
        if (textarea.needClip()) {
            return true;
        }
        if (!this.isTextWrap && this.childneedclip(textarea)) {
            return true;
        }
        BoxStyle style = textarea.getBoxStyle();
        if (style != null && (style.getBackgroundColor() != null || style.getBackgroundImage() != null || style.getBottomBorder() != null || style.getLeftBorder() != null || style.getRightBorder() != null || style.getTopBorder() != null)) {
            return true;
        }
        IContent ic = textarea.getContent();
        return ic instanceof AutoTextContent;
    }

    private boolean childneedclip(ContainerArea container) {
        if (container.needClip()) {
            return true;
        }
        Iterator<IArea> iter = container.getChildren();
        while (iter.hasNext()) {
            IArea child = iter.next();
            if (child instanceof TextArea) {
                if (!((TextArea)child).needClip()) continue;
                return true;
            }
            ContainerArea childcontainer = (ContainerArea)child;
            if (childcontainer.needClip()) {
                return true;
            }
            if (childcontainer.isEmpty() || !this.childneedclip(childcontainer)) continue;
            return true;
        }
        return false;
    }

    protected void drawCellBox(CellArea cell) {
        BoxStyle rowStyle;
        this.drawBorders(cell);
        this.drawCellDiagonal(cell);
        this.drawCellAntidiagonal(cell);
        BoxStyle style = cell.getBoxStyle();
        IStyle contentStyle = cell.getContent().getStyle();
        Color backgroundcolor = style.getBackgroundColor();
        BackgroundImageInfo bgimginfo = style.getBackgroundImage();
        if (!(this.rowStyleStack.isEmpty() || backgroundcolor != null && bgimginfo != null || (rowStyle = this.rowStyleStack.peek()) == null)) {
            if (backgroundcolor == null) {
                backgroundcolor = rowStyle.getBackgroundColor();
            }
            if (bgimginfo == null) {
                bgimginfo = rowStyle.getBackgroundImage();
            }
        }
        String imageRelationship = this.canvas.getImageRelationship(bgimginfo);
        if (bgimginfo != null) {
            bgimginfo.setImageSize(contentStyle);
        }
        if (imageRelationship != null) {
            float offsetY = 0.0f;
            float offsetX = 0.0f;
            int repeatmode = bgimginfo.getRepeatedMode();
            if (repeatmode == 0) {
                int imgheight = PPTXUtil.convertToEnums(bgimginfo.getHeightMetricPt());
                int imgwidth = PPTXUtil.convertToEnums(bgimginfo.getWidthMetricPt());
                int cellheight = PPTXUtil.convertToEnums(this.canvas.getScaledValue(cell.getHeight()));
                int cellwidth = PPTXUtil.convertToEnums(this.canvas.getScaledValue(cell.getWidth()));
                offsetY = PPTXUtil.parsePercentageOffset(cellheight, imgheight);
                offsetX = PPTXUtil.parsePercentageOffset(cellwidth, imgwidth);
            }
            this.canvas.setBackgroundImg(imageRelationship, (int)offsetX, (int)offsetY, repeatmode);
        } else if (backgroundcolor != null) {
            this.canvas.setBackgroundColor(backgroundcolor);
        }
    }

    protected void drawCellDiagonal(CellArea cell) {
        DiagonalInfo diagonalInfo = cell.getDiagonalInfo();
        if (diagonalInfo != null && diagonalInfo.getDiagonalNumber() >= 1 && diagonalInfo.getDiagonalStyle() != 28) {
            this.writer.openTag("a:lnTlToBr");
            int width = PPTXUtil.convertToEnums(diagonalInfo.getDiagonalWidth());
            this.writer.attribute("w", width);
            this.writer.attribute("cap", "flat");
            this.writer.attribute("algn", "ctr");
            this.canvas.setBackgroundColor(diagonalInfo.getDiagonalColor());
            this.writer.openTag("a:prstDash");
            this.writer.attribute("val", PPTXUtil.parseStyle(diagonalInfo.getDiagonalStyle()));
            this.writer.closeTag("a:prstDash");
            this.writer.openTag("a:round");
            this.writer.closeTag("a:round");
            this.writer.openTag("a:headEnd");
            this.writer.attribute("type", "none");
            this.writer.attribute("w", "med");
            this.writer.attribute("len", "med");
            this.writer.closeTag("a:headEnd");
            this.writer.openTag("a:tailEnd");
            this.writer.attribute("type", "none");
            this.writer.attribute("w", "med");
            this.writer.attribute("len", "med");
            this.writer.closeTag("a:tailEnd");
            this.writer.closeTag("a:lnTlToBr");
        }
    }

    protected void drawCellAntidiagonal(CellArea cell) {
        DiagonalInfo diagonalInfo = cell.getDiagonalInfo();
        if (diagonalInfo != null && diagonalInfo.getAntidiagonalNumber() >= 1 && diagonalInfo.getAntidiagonalStyle() != 28) {
            this.writer.openTag("a:lnBlToTr");
            int width = PPTXUtil.convertToEnums(diagonalInfo.getAntidiagonalWidth());
            this.writer.attribute("w", width);
            this.writer.attribute("cap", "flat");
            this.writer.attribute("algn", "ctr");
            this.canvas.setBackgroundColor(diagonalInfo.getAntidiagonalColor());
            this.writer.openTag("a:prstDash");
            this.writer.attribute("val", PPTXUtil.parseStyle(diagonalInfo.getAntidiagonalStyle()));
            this.writer.closeTag("a:prstDash");
            this.writer.openTag("a:round");
            this.writer.closeTag("a:round");
            this.writer.openTag("a:headEnd");
            this.writer.attribute("type", "none");
            this.writer.attribute("w", "med");
            this.writer.attribute("len", "med");
            this.writer.closeTag("a:headEnd");
            this.writer.openTag("a:tailEnd");
            this.writer.attribute("type", "none");
            this.writer.attribute("w", "med");
            this.writer.attribute("len", "med");
            this.writer.closeTag("a:tailEnd");
            this.writer.closeTag("a:lnBlToTr");
        }
    }

    protected void drawBorders(CellArea container) {
        BoxStyle style = container.getBoxStyle();
        if (style == null) {
            return;
        }
        BorderInfo currentborderinfo = null;
        int additionalcol = 0;
        int drawcurrentcolid = container.getColumnID();
        Integer additionalColSpan = this.mapignorecolumns.get(drawcurrentcolid);
        if (additionalColSpan != null) {
            additionalcol = additionalColSpan;
        }
        int nextCellIdx = drawcurrentcolid + this.colspan + additionalcol;
        CellArea nextcell = ((RowArea)container.getParent()).getCell(nextCellIdx);
        if (!this.isRTL) {
            this.writeSingleBorder(LEFTBORDERLINE, style.getLeftBorder());
            if (nextcell != null) {
                currentborderinfo = nextcell.getBoxStyle().getLeftBorder();
                this.writeSingleBorder(RIGHTBORDERLINE, currentborderinfo);
            }
            if (currentborderinfo == null) {
                this.writeSingleBorder(RIGHTBORDERLINE, style.getRightBorder());
            }
        } else {
            this.writeSingleBorder(LEFTBORDERLINE, style.getRightBorder());
            if (nextcell != null) {
                currentborderinfo = nextcell.getBoxStyle().getRightBorder();
                this.writeSingleBorder(RIGHTBORDERLINE, currentborderinfo);
            }
            if (currentborderinfo == null) {
                this.writeSingleBorder(RIGHTBORDERLINE, style.getLeftBorder());
            }
        }
        this.writeSingleBorder(TOPBORDERLINE, style.getTopBorder());
        currentborderinfo = null;
        RowArea rowbelow = this.getRowBelow((RowArea)container.getParent(), container.getRowSpan());
        if (rowbelow != null && rowbelow.getChildrenCount() > 0) {
            CellArea belowCell = rowbelow.getCell(drawcurrentcolid);
            if (belowCell != null) {
                currentborderinfo = belowCell.getBoxStyle().getTopBorder();
            }
            this.writeSingleBorder(BOTTOMBORDERLINE, currentborderinfo);
        }
        if (currentborderinfo == null) {
            this.writeSingleBorder(BOTTOMBORDERLINE, style.getBottomBorder());
        }
    }

    private RowArea getRowBelow(RowArea container, int spanRow) {
        return new TableVisitor().getNextRow(container, spanRow);
    }

    private void writeSingleBorder(String borderSide, BorderInfo borderinfo) {
        if (borderinfo == null) {
            return;
        }
        this.writer.openTag(borderSide);
        int width = PPTXUtil.convertToEnums(borderinfo.getWidth());
        this.writer.attribute("w", width);
        if (borderinfo.getStyle() == 23) {
            this.writer.attribute("cmpd", "dbl");
        }
        this.canvas.setBackgroundColor(borderinfo.getColor());
        this.writer.openTag("a:prstDash");
        this.writer.attribute("val", PPTXUtil.parseStyle(borderinfo.getStyle()));
        this.writer.closeTag("a:prstDash");
        this.writer.closeTag(borderSide);
    }

    private int getY(IContainerArea area) {
        return this.canvas.getScaledValue(area.getY());
    }

    private int getX(IContainerArea area) {
        return this.canvas.getScaledValue(area.getX());
    }

    protected void updateRenderXY() {
        this.render.setCurrentX(this.currentX);
        this.render.setCurrentY(this.currentY);
    }

    private class MergeCellDimension {
        private int rows;
        private final int columns;

        public MergeCellDimension(int rows, int columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public int getNumColumns() {
            return this.columns;
        }

        public void removeARow() {
            --this.rows;
        }

        public boolean isLastRow() {
            return this.rows == 1;
        }
    }
}

