/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.olap.OLAPException;
import javax.olap.cursor.DimensionCursor;
import javax.olap.cursor.EdgeCursor;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.item.crosstab.core.de.AggregationCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.i18n.Messages;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.ColumnEvent;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabCellExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.EdgeGroup;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;
import org.eclipse.birt.report.model.api.olap.LevelHandle;

public class CrosstabRowExecutor
extends BaseRowExecutor {
    private static Logger logger = Logger.getLogger(CrosstabRowExecutor.class.getName());
    private int dimensionIndex;
    private int levelIndex;
    private boolean rowEdgeStarted;
    private boolean isLayoutDownThenOver;

    public CrosstabRowExecutor(BaseCrosstabExecutor parent, int rowIndex, int dimensionIndex, int levelIndex) {
        super(parent, rowIndex);
        this.dimensionIndex = dimensionIndex;
        this.levelIndex = levelIndex;
    }

    @Override
    public IContent execute() {
        IRowContent content = this.context.getReportContent().createRowContent();
        this.initializeContent(content, null);
        this.processRowHeight(this.findDetailRowCell(this.rowIndex));
        this.processRowLevelPageBreak(content, false);
        this.prepareChildren();
        return content;
    }

    @Override
    protected void prepareChildren() {
        super.prepareChildren();
        this.initMeasureCache();
        this.rowEdgeStarted = false;
        this.isLayoutDownThenOver = "down then over".equals(this.crosstabItem.getPageLayout());
        this.walker.reload();
    }

    private AggregationCellHandle getRowSubTotalCell(int colDimensionIndex, int colLevelIndex, int measureIndex) {
        return this.getAggregationCell(this.dimensionIndex, this.levelIndex, colDimensionIndex, colLevelIndex, measureIndex);
    }

    private boolean isForceEmpty() {
        try {
            EdgeCursor rowEdgeCursor = this.getRowEdgeCursor();
            if (rowEdgeCursor != null) {
                int groupIndex = GroupUtil.getGroupIndex(this.rowGroups, this.lastDimensionIndex, this.lastLevelIndex);
                DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(groupIndex);
                return GroupUtil.isDummyGroup(dc);
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.check.force.empty"), e);
        }
        return false;
    }

    private boolean isRowEdgeNeedStart(ColumnEvent ev) throws OLAPException {
        if (this.rowEdgeStarted || ev.type != 1) {
            return false;
        }
        EdgeCursor rowEdgeCursor = this.getRowEdgeCursor();
        if (rowEdgeCursor == null) {
            return false;
        }
        boolean groupFound = false;
        int i = 0;
        while (i < this.rowGroups.size() - 1) {
            DimensionViewHandle dv;
            LevelViewHandle lv;
            EdgeGroup gp = (EdgeGroup)this.rowGroups.get(i);
            if (!groupFound && gp.dimensionIndex == ev.dimensionIndex && gp.levelIndex == ev.levelIndex) {
                groupFound = true;
            }
            if (!(this.isLayoutDownThenOver && groupFound && gp.dimensionIndex == ev.dimensionIndex && gp.levelIndex == ev.levelIndex || !groupFound || GroupUtil.isLeafGroup(rowEdgeCursor.getDimensionCursor(), i) || (lv = (dv = this.crosstabItem.getDimension(0, gp.dimensionIndex)).getLevel(gp.levelIndex)).getAggregationHeader() == null || !"before".equals(lv.getAggregationHeaderLocation()))) {
                return false;
            }
            ++i;
        }
        int gdx = GroupUtil.getGroupIndex(this.rowGroups, ev.dimensionIndex, ev.levelIndex);
        if (gdx != -1) {
            try {
                DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(gdx);
                if (!GroupUtil.isDummyGroup(dc) && rowEdgeCursor.getPosition() != dc.getEdgeStart()) {
                    return false;
                }
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.check.edge.start"), e);
            }
        }
        return this.rowIndex == 0;
    }

    @Override
    protected boolean checkMeasureVerticalSpanOverlapped(ColumnEvent ev) {
        int targetSpanGroupIndex;
        if (ev.measureIndex == -1 && this.totalMeasureCount != 1) {
            return false;
        }
        int mx = ev.measureIndex;
        if (mx == -1) {
            mx = 0;
        }
        LevelHandle spanLevel = null;
        switch (ev.type) {
            case 2: 
            case 6: {
                spanLevel = this.getMeasureCell(mx).getSpanOverOnRow();
                break;
            }
            case 3: 
            case 4: {
                int dimCount = this.crosstabItem.getDimensionCount(0);
                DimensionViewHandle rdv = this.crosstabItem.getDimension(0, dimCount - 1);
                AggregationCellHandle cellHandle = this.getAggregationCell(dimCount - 1, rdv.getLevelCount() - 1, ev.dimensionIndex, ev.levelIndex, mx);
                LevelHandle levelHandle = spanLevel = cellHandle != null ? cellHandle.getSpanOverOnRow() : null;
            }
        }
        if (spanLevel != null && (targetSpanGroupIndex = GroupUtil.getGroupIndex(this.rowGroups, spanLevel)) != -1) {
            try {
                EdgeCursor rowEdgeCursor = this.getRowEdgeCursor();
                if (rowEdgeCursor != null) {
                    if (--targetSpanGroupIndex == -1) {
                        return !rowEdgeCursor.isFirst();
                    }
                    DimensionCursor dc = (DimensionCursor)rowEdgeCursor.getDimensionCursor().get(targetSpanGroupIndex);
                    if (!GroupUtil.isDummyGroup(dc)) {
                        return rowEdgeCursor.getPosition() > dc.getEdgeStart();
                    }
                }
            }
            catch (OLAPException e) {
                logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.check.edge.start"), e);
            }
        }
        return false;
    }

    @Override
    protected void advance() {
        int mx;
        try {
            while (this.walker.hasNext()) {
                ColumnEvent ev = this.walker.next();
                switch (this.currentChangeType) {
                    case 1: {
                        if (!this.rowEdgeStarted) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        ((CrosstabCellExecutor)this.nextExecutor).setForceEmpty(this.isForceEmpty());
                        this.rowEdgeStarted = false;
                        this.hasLast = false;
                        break;
                    }
                    case 5: {
                        this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.hasLast = false;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: {
                        int n = mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                        if (this.measureDetailStarted && this.isMeetMeasureDetailEnd(ev, this.totalMeasureCount > 0 ? this.getMeasureCell(mx) : null)) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.totalMeasureCount > 0 ? this.getMeasureCell(mx) : null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.measureDetailStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (this.measureSubTotalStarted) {
                            this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                            ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                            this.measureSubTotalStarted = false;
                            this.hasLast = false;
                            break;
                        }
                        if (!this.measureGrandTotalStarted) break;
                        this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                        ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                        this.measureGrandTotalStarted = false;
                        this.hasLast = false;
                    }
                }
                if (this.isRowEdgeNeedStart(ev)) {
                    this.rowEdgeStarted = true;
                    this.rowSpan = GroupUtil.computeRowSpan(this.crosstabItem, this.rowGroups, ev.dimensionIndex, ev.levelIndex, this.getRowEdgeCursor(), this.isLayoutDownThenOver);
                    this.colSpan = 0;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (this.isMeasureDetailNeedStart(ev)) {
                    this.measureDetailStarted = true;
                    if (ev.measureIndex == -1 && this.totalMeasureCount != 1) {
                        this.rowSpan = 1;
                    } else {
                        mx = ev.measureIndex;
                        if (mx == -1) {
                            mx = 0;
                        }
                        this.rowSpan = GroupUtil.computeAggregationCellRowOverSpan(this.crosstabItem, this.rowGroups, this.getMeasureCell(mx).getSpanOverOnRow(), this.getRowEdgeCursor());
                    }
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (this.isMeasureSubTotalNeedStart(ev)) {
                    this.measureSubTotalStarted = true;
                    if (ev.measureIndex == -1 && this.totalMeasureCount != 1) {
                        this.rowSpan = 1;
                    } else {
                        mx = ev.measureIndex;
                        if (mx == -1) {
                            mx = 0;
                        }
                        this.rowSpan = GroupUtil.computeAggregationCellRowOverSpan(this.crosstabItem, this.rowGroups, (cellHandle = this.getAggregationCell((dimCount = this.crosstabItem.getDimensionCount(0)) - 1, (rdv = this.crosstabItem.getDimension(0, dimCount - 1)).getLevelCount() - 1, ev.dimensionIndex, ev.levelIndex, mx)) != null ? cellHandle.getSpanOverOnRow() : null, this.getRowEdgeCursor());
                    }
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (this.isMeasureGrandTotalNeedStart(ev)) {
                    this.measureGrandTotalStarted = true;
                    if (ev.measureIndex == -1 && this.totalMeasureCount != 1) {
                        this.rowSpan = 1;
                    } else {
                        mx = ev.measureIndex;
                        if (mx == -1) {
                            mx = 0;
                        }
                        this.rowSpan = GroupUtil.computeAggregationCellRowOverSpan(this.crosstabItem, this.rowGroups, (cellHandle = this.getAggregationCell((dimCount = this.crosstabItem.getDimensionCount(0)) - 1, (rdv = this.crosstabItem.getDimension(0, dimCount - 1)).getLevelCount() - 1, ev.dimensionIndex, ev.levelIndex, mx)) != null ? cellHandle.getSpanOverOnRow() : null, this.getRowEdgeCursor());
                    }
                    this.colSpan = 0;
                    this.lastMeasureIndex = ev.measureIndex;
                    this.lastDimensionIndex = ev.dimensionIndex;
                    this.lastLevelIndex = ev.levelIndex;
                    this.hasLast = true;
                } else if (ev.type == 5) {
                    this.rowSpan = 1;
                    this.colSpan = 0;
                    this.hasLast = true;
                }
                this.currentChangeType = ev.type;
                this.currentEdgePosition = ev.dataPosition;
                ++this.colSpan;
                ++this.currentColIndex;
                if (this.nextExecutor == null) continue;
                return;
            }
        }
        catch (OLAPException e) {
            logger.log(Level.SEVERE, Messages.getString("CrosstabRowExecutor.error.retrieve.child.executor"), e);
        }
        if (this.hasLast) {
            this.hasLast = false;
            switch (this.currentChangeType) {
                case 1: {
                    if (!this.rowEdgeStarted) break;
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getDimension(0, this.lastDimensionIndex).getLevel(this.lastLevelIndex).getCell(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    ((CrosstabCellExecutor)this.nextExecutor).setForceEmpty(this.isForceEmpty());
                    this.rowEdgeStarted = false;
                    break;
                }
                case 5: {
                    this.nextExecutor = new CrosstabCellExecutor(this, this.crosstabItem.getMeasure(this.rowIndex).getHeader(), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                    ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                    break;
                }
            }
            if (this.measureDetailStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.totalMeasureCount > 0 ? this.getMeasureCell(mx) : null, this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureDetailStarted = false;
            } else if (this.measureSubTotalStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureSubTotalStarted = false;
            } else if (this.measureGrandTotalStarted) {
                mx = this.lastMeasureIndex < 0 ? this.rowIndex : this.lastMeasureIndex;
                this.nextExecutor = new CrosstabCellExecutor(this, this.getRowSubTotalCell(this.lastDimensionIndex, this.lastLevelIndex, mx), this.rowSpan, this.colSpan, this.currentColIndex - this.colSpan + 1);
                ((CrosstabCellExecutor)this.nextExecutor).setPosition(this.currentEdgePosition);
                this.measureGrandTotalStarted = false;
            }
        }
    }
}

