/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.script.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstab;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabCell;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabCellInstance;
import org.eclipse.birt.report.item.crosstab.core.script.ICrosstabInstance;
import org.eclipse.birt.report.item.crosstab.core.script.internal.CrosstabArgumentInfoList;
import org.eclipse.birt.report.model.api.scripts.MethodInfo;

public class CrosstabMethodInfo
extends MethodInfo {
    private List<CrosstabArgumentInfoList> argumentInfos;
    private static final Map<String, String> javaDoc = new HashMap<String, String>();

    static {
        javaDoc.put("onPrepareCrosstab", "/**\n * Called when crosstab is being prepared.\n *\n * @param crosstab\n *            ICrosstab\n * @param reportContext\n *            IReportContext\n */\n");
        javaDoc.put("onPrepareCell", "/**\n * Called when crosstab cell is being prepared.\n *\n * @param cell\n *            ICrosstabCell\n * @param reportContext\n *            IReportContext\n */\n");
        javaDoc.put("onCreateCrosstab", "/**\n * Called when crosstab is being created.\n *\n * @param crosstabInst\n *            ICrosstabInstance\n * @param reportContext\n *            IReportContext\n */\n");
        javaDoc.put("onCreateCell", "/**\n * Called when crosstab cell is being created.\n *\n * @param cellInst\n *            ICrosstabCellInstance\n * @param reportContext\n *            IReportContext\n */\n");
        javaDoc.put("onRenderCrosstab", "/**\n * Called when crosstab is being rendered.\n *\n * @param crosstabInst\n *            ICrosstabInstance\n * @param reportContext\n *            IReportContext\n */\n");
        javaDoc.put("onRenderCell", "/**\n * Called when crosstab cell is being rendered.\n *\n * @param cellInst\n *            ICrosstabCellInstance\n * @param reportContext\n *            IReportContext\n */\n");
    }

    CrosstabMethodInfo(Method method) {
        super(method);
        this.initArgumentList(method.getParameterTypes());
    }

    private void initArgumentList(Class<?>[] argumentList) {
        if (this.argumentInfos == null) {
            this.argumentInfos = new ArrayList<CrosstabArgumentInfoList>();
        }
        String[] argNames = this.populateArgNames(argumentList);
        CrosstabArgumentInfoList argumentInfoList = new CrosstabArgumentInfoList(argumentList, argNames);
        this.argumentInfos.add(argumentInfoList);
    }

    private String[] populateArgNames(Class<?>[] types) {
        if (types != null) {
            String[] names = new String[types.length];
            int i = 0;
            while (i < names.length) {
                names[i] = this.getArgName(types[i]);
                ++i;
            }
            return names;
        }
        return null;
    }

    private String getArgName(Class<?> type) {
        if (type == IReportContext.class) {
            return "reportContext";
        }
        if (type == ICrosstab.class) {
            return "crosstab";
        }
        if (type == ICrosstabInstance.class) {
            return "crosstabInst";
        }
        if (type == ICrosstabCell.class) {
            return "cell";
        }
        if (type == ICrosstabCellInstance.class) {
            return "cellInst";
        }
        return null;
    }

    @Override
    public Iterator argumentListIterator() {
        if (this.argumentInfos == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.argumentInfos.iterator();
    }

    public boolean isDeprecated() {
        String javaDoc = this.getJavaDoc();
        return javaDoc != null && javaDoc.indexOf("@deprecated") != -1;
    }

    @Override
    public String getJavaDoc() {
        return javaDoc.get(this.getMethod().getName());
    }
}

