/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.ReferenceValueUtil;

public abstract class PropertyStructure
extends Structure {
    protected HashMap<String, Object> propValues = new HashMap();

    @Override
    public Object getLocalProperty(Module module, PropertyDefn propDefn) {
        Object value = null;
        value = propDefn.isIntrinsic() ? this.getIntrinsicProperty(propDefn.getName()) : this.propValues.get(propDefn.getName());
        if (propDefn.getTypeCode() == 15) {
            return ReferenceValueUtil.resolveElementReference(this, module, (StructPropertyDefn)propDefn, value);
        }
        return value;
    }

    @Override
    public Object getLocalProperty(Module module, String memberName) {
        PropertyDefn prop = (PropertyDefn)this.getDefn().getMember(memberName);
        if (prop == null) {
            return null;
        }
        return this.getLocalProperty(module, prop);
    }

    @Override
    public final void setProperty(PropertyDefn prop, Object value) {
        assert (prop != null);
        Object newValue = this.getCompatibleValue(prop, value);
        this.updateReference(prop, newValue);
        this.setupContext(prop, newValue);
        if (prop.isIntrinsic()) {
            this.setIntrinsicProperty(prop.getName(), newValue);
        } else if (value == null) {
            this.propValues.remove(prop.getName());
        } else {
            this.propValues.put(prop.getName(), newValue);
        }
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        assert (false);
        return null;
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        assert (false);
    }

    public Object clone() throws CloneNotSupportedException {
        PropertyStructure clone = (PropertyStructure)super.clone();
        clone.propValues = new HashMap();
        for (String memberName : this.propValues.keySet()) {
            ElementRefValue refValue;
            Structure struct;
            IPropertyDefn memberDefn = this.getDefn().getMember(memberName);
            Object value = null;
            value = memberDefn.getTypeCode() == 16 ? (memberDefn.isList() ? ModelUtil.cloneStructList((ArrayList)this.propValues.get(memberName)) : ((struct = (Structure)this.propValues.get(memberName)) == null ? null : struct.copy())) : (memberDefn.getTypeCode() == 15 ? ((refValue = (ElementRefValue)this.propValues.get(memberName)) == null ? null : refValue.copy()) : this.propValues.get(memberName));
            clone.propValues.put(memberName, value);
        }
        return clone;
    }
}

