/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.data.adapter.api.DimensionLevel;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.ScriptNode;

public class CubeQueryUtil {
    public static List getReferencedLevels(String targetLevel, String bindingExpr, List bindings, List rowEdgeExprList, List columnEdgeExprList) throws AdapterException {
        try {
            int candidateEdge;
            ArrayList result = new ArrayList();
            DimensionLevel target = CubeQueryUtil.getTargetDimLevel(targetLevel);
            String bindingName = CubeQueryUtil.getReferencedScriptObject(bindingExpr, "data");
            if (bindingName == null) {
                return result;
            }
            IBinding binding = null;
            int i = 0;
            while (i < bindings.size()) {
                IBinding bd = (IBinding)bindings.get(i);
                if (bd.getBindingName().equals(bindingName)) {
                    binding = bd;
                    break;
                }
                ++i;
            }
            if (binding == null) {
                return result;
            }
            List aggrOns = binding.getAggregatOns();
            boolean isMeasure = false;
            if (aggrOns.size() == 0) {
                boolean bl = isMeasure = CubeQueryUtil.getReferencedScriptObject(binding.getExpression(), "measure") != null;
                if (!isMeasure) {
                    boolean bl2 = isMeasure = CubeQueryUtil.getReferencedScriptObject(binding.getExpression(), "data") != null;
                }
            }
            if ((candidateEdge = CubeQueryUtil.getAxisQualifierEdgeType(rowEdgeExprList, columnEdgeExprList, target)) == -1) {
                return result;
            }
            if (isMeasure) {
                switch (candidateEdge) {
                    case 1: {
                        CubeQueryUtil.populateLevels(rowEdgeExprList, result);
                        break;
                    }
                    case 2: {
                        CubeQueryUtil.populateLevels(columnEdgeExprList, result);
                    }
                }
            } else {
                switch (candidateEdge) {
                    case 1: {
                        CubeQueryUtil.populateAxisLevels(aggrOns, rowEdgeExprList, result);
                        CubeQueryUtil.populateAnotherAxisLevels(aggrOns, columnEdgeExprList, result, targetLevel);
                        break;
                    }
                    case 2: {
                        CubeQueryUtil.populateAxisLevels(aggrOns, columnEdgeExprList, result);
                        CubeQueryUtil.populateAnotherAxisLevels(aggrOns, rowEdgeExprList, result, targetLevel);
                    }
                }
            }
            return result;
        }
        catch (DataException e) {
            throw new AdapterException(e.getLocalizedMessage(), e);
        }
    }

    public static List getReferencedLevelsForLinkedCube(String targetLevel, String bindingExpr, List bindings, List rowEdgeExprList, List columnEdgeExprList) throws AdapterException {
        return CubeQueryUtil.getReferencedLevels(targetLevel, bindingExpr, bindings, rowEdgeExprList, columnEdgeExprList);
    }

    public static IBinding[] getAggregationBindings(IBinding[] bindings) throws AdapterException {
        assert (bindings != null);
        ArrayList<IBinding> result = new ArrayList<IBinding>();
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding b = iBindingArray[n2];
            try {
                if (b.getAggrFunction() != null) {
                    result.add(b);
                }
            }
            catch (DataException e) {
                throw new AdapterException(e.getLocalizedMessage(), e);
            }
            ++n2;
        }
        return result.toArray(new IBinding[0]);
    }

    private static void populateAxisLevels(List aggrOns, List edgeExprList, List result) throws AdapterException {
        int i = 0;
        while (i < aggrOns.size()) {
            String levelExpr = aggrOns.get(i).toString();
            if (CubeQueryUtil.isAxisQualifierLevel(levelExpr, edgeExprList)) {
                result.add(CubeQueryUtil.getTargetDimLevel(levelExpr));
            }
            ++i;
        }
    }

    private static void populateAnotherAxisLevels(List aggrOns, List edgeExprList, List result, String targetLevel) throws AdapterException {
        boolean issubLevel = false;
        int i = 0;
        while (i < aggrOns.size()) {
            String levelExpr = aggrOns.get(i).toString();
            if (levelExpr.equals(targetLevel)) {
                issubLevel = true;
            }
            if (CubeQueryUtil.isAxisQualifierLevel(levelExpr, edgeExprList) && CubeQueryUtil.isSubLevel(levelExpr, targetLevel, issubLevel)) {
                result.add(CubeQueryUtil.getTargetDimLevel(levelExpr));
            }
            ++i;
        }
    }

    private static boolean isSubLevel(String levelExpr, String targetLevel, boolean issubLevel) throws AdapterException {
        if (levelExpr.equals(targetLevel)) {
            return false;
        }
        return issubLevel;
    }

    private static boolean isAxisQualifierLevel(String levelExpr, List rowEdgeExprList) {
        for (String expr : rowEdgeExprList) {
            if (!expr.equals(levelExpr)) continue;
            return true;
        }
        return false;
    }

    private static void populateLevels(List levelExprList, List result) throws AdapterException {
        for (String levelExpr : levelExprList) {
            result.add(CubeQueryUtil.getTargetDimLevel(levelExpr));
        }
    }

    private static int getAxisQualifierEdgeType(List rowEdgeList, List columnEdgeList, DimensionLevel target) throws AdapterException {
        DimensionLevel level;
        if (rowEdgeList != null) {
            for (String levelExpr : rowEdgeList) {
                level = CubeQueryUtil.getTargetDimLevel(levelExpr);
                if (!target.getDimensionName().equals(level.getDimensionName())) continue;
                return 2;
            }
        }
        if (columnEdgeList != null) {
            for (String levelExpr : columnEdgeList) {
                level = CubeQueryUtil.getTargetDimLevel(levelExpr);
                if (!target.getDimensionName().equals(level.getDimensionName())) continue;
                return 1;
            }
        }
        return -1;
    }

    private static String getReferencedScriptObject(IBaseExpression expr, String objectName) {
        if (expr instanceof IScriptExpression) {
            return CubeQueryUtil.getReferencedScriptObject((IScriptExpression)expr, objectName);
        }
        if (expr instanceof IConditionalExpression) {
            IScriptExpression expr1 = ((IConditionalExpression)expr).getExpression();
            String dimName = CubeQueryUtil.getReferencedScriptObject(expr1, objectName);
            if (dimName != null) {
                return dimName;
            }
            IBaseExpression op1 = ((IConditionalExpression)expr).getOperand1();
            dimName = CubeQueryUtil.getReferencedScriptObject(op1, objectName);
            if (dimName != null) {
                return dimName;
            }
            IBaseExpression op2 = ((IConditionalExpression)expr).getOperand2();
            dimName = CubeQueryUtil.getReferencedScriptObject(op2, objectName);
            return dimName;
        }
        return null;
    }

    private static String getReferencedScriptObject(IScriptExpression expr, String objectName) {
        if (expr == null) {
            return null;
        }
        return CubeQueryUtil.getReferencedScriptObject(expr.getText(), objectName);
    }

    private static String getReferencedScriptObject(String expr, String objectName) {
        if (expr == null) {
            return null;
        }
        try {
            Context cx = Context.enter();
            CompilerEnvirons ce = new CompilerEnvirons();
            Parser p = new Parser(ce, cx.getErrorReporter());
            AstRoot tree = p.parse(expr, null, 0);
            IRFactory ir = new IRFactory(ce, "");
            ScriptNode script = ir.transformTree(tree);
            String string = CubeQueryUtil.getScriptObjectName((Node)script, objectName);
            return string;
        }
        finally {
            Context.exit();
        }
    }

    private static String getScriptObjectName(Node n, String objectName) {
        if (n == null) {
            return null;
        }
        if (n.getType() == 44 && objectName.equals(n.getString())) {
            Node dimNameNode = n.getNext();
            if (dimNameNode == null || dimNameNode.getType() != 46) {
                return null;
            }
            return dimNameNode.getString();
        }
        String result = CubeQueryUtil.getScriptObjectName(n.getFirstChild(), objectName);
        if (result == null) {
            result = CubeQueryUtil.getScriptObjectName(n.getLastChild(), objectName);
        }
        return result;
    }

    private static String[] getTargetLevel(String expr) {
        if (expr == null || !expr.matches("\\Qdimension[\"\\E.*\\Q\"][\"\\E.*\\Q\"]\\E")) {
            return null;
        }
        expr = expr.replaceFirst("\\Qdimension\\E", "");
        String[] result = expr.split("\\Q\"][\"\\E");
        result[0] = result[0].replaceAll("\\Q[\"\\E", "");
        result[1] = result[1].replaceAll("\\Q\"]\\E", "");
        return result;
    }

    private static DimensionLevel getTargetDimLevel(String expr) throws AdapterException {
        String[] target = CubeQueryUtil.getTargetLevel(expr);
        if (target == null || target.length < 2) {
            throw new AdapterException("invalid.level.expression", expr);
        }
        return new DimensionLevel(target[0], target[1]);
    }
}

