/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.metadata.ODAExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.parser.TextState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ExtendedPropertyState
extends StructureState {
    protected String encryptionID = null;

    ExtendedPropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn) {
        super(theHandler, element, propDefn);
        if ("privateDriverProperties".equalsIgnoreCase(propDefn.getName())) {
            this.struct = new ExtendedProperty();
        } else {
            this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.WRONG_EXTENDED_PROPERTY_TYPE")));
        }
    }

    @Override
    public AbstractParseState startElement(String tagName) {
        assert (this.struct instanceof ExtendedProperty);
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.NAME_ATTRIB == tagValue) {
            return new TextState(this.handler, this.struct, "name");
        }
        if (ParserSchemaConstants.VALUE_TAG == tagValue) {
            return new TextState(this.handler, this.struct, "value");
        }
        return super.startElement(tagName);
    }

    @Override
    public void parseAttrs(Attributes attrs) throws XMLParserException {
        super.parseAttrs(attrs);
        this.encryptionID = attrs.getValue("encryptionID");
        ((ExtendedProperty)this.struct).setEncryptionID(this.encryptionID);
        assert (this.struct instanceof ExtendedProperty);
    }

    @Override
    public void end() throws SAXException {
        super.end();
        String encryptionID = ((ExtendedProperty)this.struct).getEncryptionID();
        String value = ((ExtendedProperty)this.struct).getValue();
        if (!StringUtil.isBlank(encryptionID) && !StringUtil.isBlank(value)) {
            String name = ((ExtendedProperty)this.struct).getName();
            boolean isEncryptable = false;
            List<IElementPropertyDefn> hidePrivatePropsList = null;
            IElementDefn tmpElementDefn = this.element.getDefn();
            if (tmpElementDefn instanceof ODAExtensionElementDefn) {
                hidePrivatePropsList = ((ODAExtensionElementDefn)tmpElementDefn).getHidePrivateProps();
            }
            IElementPropertyDefn oadPropertyDefn = null;
            if (hidePrivatePropsList != null && hidePrivatePropsList.size() > 0) {
                for (IElementPropertyDefn defn : hidePrivatePropsList) {
                    if (!name.equals(defn.getName()) || !defn.isEncryptable()) continue;
                    isEncryptable = true;
                    oadPropertyDefn = defn;
                    break;
                }
            }
            if (isEncryptable) {
                String valueToSet = StringUtil.trimString(value);
                valueToSet = (String)EncryptionUtil.decrypt((PropertyDefn)((Object)oadPropertyDefn), encryptionID, (Object)valueToSet);
                PropertyDefn pd = (PropertyDefn)this.struct.getDefn().findProperty("value");
                this.struct.setProperty(pd, valueToSet);
            }
        }
    }
}

