/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.text.pdf;

import java.awt.font.GlyphVector;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openpdf.text.ExceptionConverter;
import org.openpdf.text.TextRenderingOptions;
import org.openpdf.text.Utilities;
import org.openpdf.text.pdf.BaseFont;
import org.openpdf.text.pdf.CJKFont;
import org.openpdf.text.pdf.FopGlyphProcessor;
import org.openpdf.text.pdf.IntHashtable;
import org.openpdf.text.pdf.PdfEncodings;
import org.openpdf.text.pdf.PdfIndirectReference;
import org.openpdf.text.pdf.PdfName;
import org.openpdf.text.pdf.PdfWriter;
import org.openpdf.text.pdf.TrueTypeFontUnicode;

class FontDetails {
    protected boolean subset = true;
    PdfIndirectReference indirectReference;
    PdfName fontName;
    BaseFont baseFont;
    TrueTypeFontUnicode ttu;
    CJKFont cjkFont;
    byte[] shortTag;
    HashMap<Integer, int[]> longTag;
    IntHashtable cjkTag;
    int fontType;
    boolean symbolic;
    private Map<Integer, int[]> fillerCmap;

    FontDetails(PdfName fontName, PdfIndirectReference indirectReference, BaseFont baseFont) {
        this.fontName = fontName;
        this.indirectReference = indirectReference;
        this.baseFont = baseFont;
        this.fontType = baseFont.getFontType();
        switch (this.fontType) {
            case 0: 
            case 1: {
                this.shortTag = new byte[256];
                break;
            }
            case 2: {
                this.cjkTag = new IntHashtable();
                this.cjkFont = (CJKFont)baseFont;
                break;
            }
            case 3: {
                this.longTag = new HashMap();
                this.fillerCmap = new HashMap<Integer, int[]>();
                this.ttu = (TrueTypeFontUnicode)baseFont;
                this.symbolic = baseFont.isFontSpecific();
            }
        }
    }

    Map<Integer, int[]> getFillerCmap() {
        return this.fillerCmap;
    }

    void putFillerCmap(Integer key, int[] value) {
        this.fillerCmap.put(key, value);
    }

    void addMissingCmapEntries(String text, GlyphVector glyphVector, BaseFont baseFont) {
        if (baseFont instanceof TrueTypeFontUnicode) {
            TrueTypeFontUnicode trueTypeFont = (TrueTypeFontUnicode)baseFont;
            if (this.getFillerCmap() != null) {
                int[][] localCmap;
                for (int[] ints : localCmap = trueTypeFont.getSentenceMissingCmap(text, glyphVector)) {
                    this.putFillerCmap(ints[0], new int[]{ints[0], ints[1]});
                }
            }
        }
    }

    PdfIndirectReference getIndirectReference() {
        return this.indirectReference;
    }

    PdfName getFontName() {
        return this.fontName;
    }

    BaseFont getBaseFont() {
        return this.baseFont;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] convertToBytes(String text, TextRenderingOptions options) {
        byte[] b = null;
        switch (this.fontType) {
            case 5: {
                return this.baseFont.convertToBytes(text);
            }
            case 0: 
            case 1: {
                byte[] byArray = b = this.baseFont.convertToBytes(text);
                int n = byArray.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b1 = byArray[n2];
                    this.shortTag[b1 & 0xFF] = 1;
                    ++n2;
                }
                return b;
            }
            case 2: {
                int len = text.length();
                int k = 0;
                while (k < len) {
                    this.cjkTag.put(this.cjkFont.getCidCode(text.charAt(k)), 0);
                    ++k;
                }
                return this.baseFont.convertToBytes(text);
            }
            case 4: {
                return this.baseFont.convertToBytes(text);
            }
            case 3: {
                try {
                    int len = text.length();
                    int[] metrics = null;
                    char[] glyph = new char[len];
                    int i = 0;
                    if (this.symbolic) {
                        b = PdfEncodings.convertToBytes(text, "symboltt");
                        len = b.length;
                        for (int k = 0; k < len; ++k) {
                            metrics = this.ttu.getMetricsTT(b[k] & 0xFF);
                            if (metrics == null) continue;
                            this.longTag.put(metrics[0], new int[]{metrics[0], metrics[1], this.ttu.getUnicodeDifferences(b[k] & 0xFF)});
                            glyph[i++] = (char)metrics[0];
                        }
                        String s = new String(glyph, 0, i);
                        return s.getBytes("UnicodeBigUnmarked");
                    }
                    String fileName = ((TrueTypeFontUnicode)this.getBaseFont()).fileName;
                    if (!options.isGlyphSubstitutionEnabled()) return this.convertToBytesWithGlyphs(text);
                    if (!FopGlyphProcessor.isFopSupported()) return this.convertToBytesWithGlyphs(text);
                    if (fileName == null) return this.convertToBytesWithGlyphs(text);
                    if (fileName.length() <= 0) return this.convertToBytesWithGlyphs(text);
                    if (fileName.contains(".ttf")) return FopGlyphProcessor.convertToBytesWithGlyphs(this.ttu, text, fileName, this.longTag, options.getDocumentLanguage());
                    if (!fileName.contains(".TTF")) return this.convertToBytesWithGlyphs(text);
                    return FopGlyphProcessor.convertToBytesWithGlyphs(this.ttu, text, fileName, this.longTag, options.getDocumentLanguage());
                }
                catch (UnsupportedEncodingException e) {
                    throw new ExceptionConverter(e);
                }
            }
        }
        return b;
    }

    private byte[] convertToBytesWithGlyphs(String text) {
        int len = text.length();
        int[] metrics = null;
        int[] glyph = new int[len];
        int i = 0;
        for (int k = 0; k < len; ++k) {
            int val;
            if (Utilities.isSurrogatePair(text, k)) {
                val = Utilities.convertToUtf32(text, k);
                ++k;
            } else {
                val = text.charAt(k);
            }
            metrics = this.ttu.getMetricsTT(val);
            if (metrics == null) continue;
            int m0 = metrics[0];
            int m1 = metrics[1];
            this.longTag.computeIfAbsent(m0, key -> new int[]{m0, m1, val});
            glyph[i++] = m0;
        }
        return this.getCJKEncodingBytes(glyph, i);
    }

    private byte[] getCJKEncodingBytes(int[] glyph, int size) {
        byte[] result = new byte[size * 2];
        for (int i = 0; i < size; ++i) {
            int g = glyph[i];
            result[i * 2] = (byte)(g >> 8);
            result[i * 2 + 1] = (byte)(g & 0xFF);
        }
        return result;
    }

    byte[] convertToBytes(List<Integer> glyphCodes) {
        if (this.fontType != 3) {
            throw new UnsupportedOperationException("Only supported for True Type Unicode fonts");
        }
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        for (int glyphCode : glyphCodes) {
            int[] nArray;
            if (glyphCode == 65534 || glyphCode == 65535) {
                return new byte[0];
            }
            codePoints.add(glyphCode);
            if (this.longTag.containsKey(glyphCode)) continue;
            int glyphWidth = this.ttu.getGlyphWidth(glyphCode);
            Integer charCode = this.ttu.getCharacterCode(glyphCode);
            if (charCode != null) {
                int[] nArray2 = new int[3];
                nArray2[0] = glyphCode;
                nArray2[1] = glyphWidth;
                nArray = nArray2;
                nArray2[2] = charCode;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = glyphCode;
                nArray = nArray3;
                nArray3[1] = glyphWidth;
            }
            int[] metrics = nArray;
            this.longTag.put(glyphCode, metrics);
        }
        return FontDetails.getBytesFromCodePoints(codePoints);
    }

    private static byte[] getBytesFromCodePoints(List<Integer> codePoints) {
        int[] codePointsArray = new int[codePoints.size()];
        for (int i = 0; i < codePoints.size(); ++i) {
            codePointsArray[i] = codePoints.get(i);
        }
        String s = new String(codePointsArray, 0, codePointsArray.length);
        return s.getBytes(StandardCharsets.UTF_16BE);
    }

    byte[] convertToBytes(GlyphVector glyphVector, int beginIndex, int endIndex) {
        if (this.fontType != 3 || this.symbolic) {
            throw new UnsupportedOperationException("Only supported for True Type Unicode fonts");
        }
        ArrayList<Integer> codePoints = new ArrayList<Integer>();
        for (int i = beginIndex; i < endIndex; ++i) {
            int[] nArray;
            int code = glyphVector.getGlyphCode(i);
            if (code == 65534 || code == 65535) continue;
            codePoints.add(code);
            Integer codeKey = code;
            if (this.longTag.containsKey(codeKey)) continue;
            int glyphWidth = this.ttu.getGlyphWidth(code);
            Integer charCode = this.ttu.getCharacterCode(code);
            if (charCode != null) {
                int[] nArray2 = new int[3];
                nArray2[0] = code;
                nArray2[1] = glyphWidth;
                nArray = nArray2;
                nArray2[2] = charCode;
            } else {
                int[] nArray3 = new int[2];
                nArray3[0] = code;
                nArray = nArray3;
                nArray3[1] = glyphWidth;
            }
            int[] metrics = nArray;
            this.longTag.put(codeKey, metrics);
        }
        return FontDetails.getBytesFromCodePoints(codePoints);
    }

    void writeFont(PdfWriter writer) {
        try {
            switch (this.fontType) {
                case 5: {
                    this.baseFont.writeFont(writer, this.indirectReference, null);
                    break;
                }
                case 0: 
                case 1: {
                    int lastChar;
                    int firstChar;
                    for (firstChar = 0; firstChar < 256 && this.shortTag[firstChar] == 0; ++firstChar) {
                    }
                    for (lastChar = 255; lastChar >= firstChar && this.shortTag[lastChar] == 0; --lastChar) {
                    }
                    if (firstChar > 255) {
                        firstChar = 255;
                        lastChar = 255;
                    }
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{firstChar, lastChar, this.shortTag, this.subset});
                    break;
                }
                case 2: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.cjkTag});
                    break;
                }
                case 3: {
                    this.baseFont.writeFont(writer, this.indirectReference, new Object[]{this.longTag, this.subset, this.getFillerCmap()});
                }
            }
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean subset) {
        this.subset = subset;
    }
}

