/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExecutableInvoker;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.engine.execution.ParameterResolutionUtils;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.support.MethodReflectionUtils;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.INTERNAL, since="5.9")
public class DefaultExecutableInvoker
implements ExecutableInvoker {
    private final ExtensionContext extensionContext;
    private final ExtensionRegistry extensionRegistry;

    public DefaultExecutableInvoker(ExtensionContext extensionContext, ExtensionRegistry extensionRegistry) {
        this.extensionContext = extensionContext;
        this.extensionRegistry = extensionRegistry;
    }

    public <T> T invoke(Constructor<T> constructor, @Nullable Object outerInstance) {
        @Nullable Object[] arguments = ParameterResolutionUtils.resolveParameters(constructor, Optional.empty(), Optional.ofNullable(outerInstance), this.extensionContext, this.extensionRegistry);
        return (T)ReflectionUtils.newInstance(constructor, (Object[])arguments);
    }

    public @Nullable Object invoke(Method method, @Nullable Object target) {
        @Nullable Object[] arguments = ParameterResolutionUtils.resolveParameters(method, Optional.ofNullable(target), this.extensionContext, this.extensionRegistry);
        return MethodReflectionUtils.invoke(method, target, arguments);
    }
}

