/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.diag;

import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.shared.common.error.StandardException;

abstract class DiagUtil {
    DiagUtil() {
    }

    static void checkAccess() throws StandardException {
        String currentUser;
        String databaseOwner;
        LanguageConnectionContext lcc = (LanguageConnectionContext)DiagUtil.getContextOrNull("LanguageConnectionContext");
        DataDictionary dd = lcc.getDataDictionary();
        if (dd.usesSqlAuthorization() && !(databaseOwner = dd.getAuthorizationDatabaseOwner()).equals(currentUser = lcc.getStatementContext().getSQLSessionContext().getCurrentUser())) {
            throw StandardException.newException("4251D", new Object[0]);
        }
    }

    private static Context getContextOrNull(String contextID) {
        return ContextService.getContextOrNull(contextID);
    }
}

