/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.dblook;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.impl.tools.dblook.Logs;
import org.apache.derby.tools.dblook;

public class DB_Trigger {
    private static final String TRIGGERNAME = "TRIGGERNAME";
    private static final String SCHEMAID = "SCHEMAID";
    private static final String EVENT = "EVENT";
    private static final String FIRINGTIME = "FIRINGTIME";
    private static final String TYPE = "TYPE";
    private static final String TABLEID = "TABLEID";
    private static final String REFERENCEDCOLUMNS = "REFERENCEDCOLUMNS";
    private static final String TRIGGERDEFINITION = "TRIGGERDEFINITION";
    private static final String REFERENCINGOLD = "REFERENCINGOLD";
    private static final String REFERENCINGNEW = "REFERENCINGNEW";
    private static final String OLDREFERENCINGNAME = "OLDREFERENCINGNAME";
    private static final String NEWREFERENCINGNAME = "NEWREFERENCINGNAME";
    private static final String WHENCLAUSETEXT = "WHENCLAUSETEXT";

    public static void doTriggers(Connection conn, boolean supportsWhenClause) throws SQLException {
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT * FROM SYS.SYSTRIGGERS WHERE STATE != 'D' ORDER BY CREATIONTIMESTAMP");
        boolean firstTime = true;
        while (rs.next()) {
            String whenClause;
            Object trigName = dblook.addQuotes(dblook.expandDoubleQuotes(rs.getString(TRIGGERNAME)));
            String trigSchema = dblook.lookupSchemaId(rs.getString(SCHEMAID));
            if (dblook.isIgnorableSchema(trigSchema)) continue;
            trigName = trigSchema + "." + (String)trigName;
            String tableName = dblook.lookupTableId(rs.getString(TABLEID));
            String string = whenClause = supportsWhenClause ? rs.getString(WHENCLAUSETEXT) : null;
            if (!dblook.stringContainsTargetTable(rs.getString(TRIGGERDEFINITION)) && !dblook.stringContainsTargetTable(whenClause) && dblook.isExcludedTable(tableName)) continue;
            if (firstTime) {
                Logs.reportString("----------------------------------------------");
                Logs.reportMessage("DBLOOK_TriggersHeader");
                Logs.reportString("----------------------------------------------\n");
            }
            String createTrigString = DB_Trigger.createTrigger((String)trigName, tableName, whenClause, rs);
            Logs.writeToNewDDL(createTrigString);
            Logs.writeStmtEndToNewDDL();
            Logs.writeNewlineToNewDDL();
            firstTime = false;
        }
        rs.close();
        stmt.close();
    }

    private static String createTrigger(String trigName, String tableName, String whenClause, ResultSet aTrig) throws SQLException {
        StringBuilder sb = new StringBuilder("CREATE TRIGGER ");
        sb.append(trigName);
        if (aTrig.getString(FIRINGTIME).charAt(0) == 'A') {
            sb.append(" AFTER ");
        } else {
            sb.append(" NO CASCADE BEFORE ");
        }
        String event = aTrig.getString(EVENT);
        switch (event.charAt(0)) {
            case 'I': {
                sb.append("INSERT");
                break;
            }
            case 'D': {
                sb.append("DELETE");
                break;
            }
            case 'U': {
                sb.append("UPDATE");
                String updateCols = aTrig.getString(REFERENCEDCOLUMNS);
                if (aTrig.wasNull() || updateCols.equals("NULL")) break;
                sb.append(" OF ");
                sb.append(dblook.getColumnListFromDescription(aTrig.getString(TABLEID), updateCols));
                break;
            }
            default: {
                Logs.debug("INTERNAL ERROR: unexpected trigger event: " + event, (String)null);
            }
        }
        sb.append(" ON ");
        sb.append(tableName);
        char trigType = aTrig.getString(TYPE).charAt(0);
        String oldReferencing = aTrig.getString(OLDREFERENCINGNAME);
        String newReferencing = aTrig.getString(NEWREFERENCINGNAME);
        if (oldReferencing != null || newReferencing != null) {
            sb.append(" REFERENCING");
            if (aTrig.getBoolean(REFERENCINGOLD)) {
                sb.append(" OLD");
                if (trigType == 'S') {
                    sb.append("_TABLE AS ");
                } else {
                    sb.append(" AS ");
                }
                sb.append(oldReferencing);
            }
            if (aTrig.getBoolean(REFERENCINGNEW)) {
                sb.append(" NEW");
                if (trigType == 'S') {
                    sb.append("_TABLE AS ");
                } else {
                    sb.append(" AS ");
                }
                sb.append(newReferencing);
            }
        }
        sb.append(" FOR EACH ");
        if (trigType == 'S') {
            sb.append("STATEMENT ");
        } else {
            sb.append("ROW ");
        }
        if (whenClause != null) {
            sb.append("WHEN (");
            sb.append(dblook.removeNewlines(whenClause));
            sb.append(") ");
        }
        sb.append(dblook.removeNewlines(aTrig.getString(TRIGGERDEFINITION)));
        return sb.toString();
    }
}

