/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.ArchiveReader;
import org.eclipse.birt.core.archive.compound.ArchiveWriter;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.junit.Test;

public class BufferTest
extends TestCase {
    static int TEST_COUNT = 1024;
    static int LENGTH = 0x100000;
    static String ENTRY_NAME = "/test/abc.dat";
    static String ARCHIVE_NAME = "datafile.dat";
    static int[] sizes = new int[]{1, 7, 13, 31, 61, 113, 251, 509, 1021, 2039, 4091, 4093};

    @Test
    public void testBuffer() throws IOException {
        ArchiveFile af = new ArchiveFile(ARCHIVE_NAME, "rwt");
        try {
            ArchiveWriter writer = new ArchiveWriter((IArchiveFile)af);
            ArchiveReader reader = new ArchiveReader((IArchiveFile)af);
            System.out.println("warm....");
            BufferTest.testWriteByte(writer);
            BufferTest.testReadByte(reader);
            BufferTest.testWriteInteger(writer);
            BufferTest.testReadInteger(reader);
            BufferTest.testWriteLong(writer);
            BufferTest.testReadLong(reader);
            BufferTest.testWriteBytes(writer);
            BufferTest.testReadBytes(reader);
            System.out.println();
        }
        finally {
            af.close();
            new File(ARCHIVE_NAME).delete();
        }
    }

    static void testByte(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("byte");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testWriteByte(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testReadByte(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteByte(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                int i = 0;
                while (i < LENGTH) {
                    out.write(i);
                    ++i;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void testReadByte(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                int i = 0;
                while (i < LENGTH) {
                    int n = in.read();
                    ++i;
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void testInteger(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("integer");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testWriteInteger(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testReadInteger(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteInteger(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                int length = LENGTH / 4;
                int i = 0;
                while (i < length) {
                    out.writeInt(i);
                    ++i;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void testReadInteger(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                int count = 0;
                try {
                    while (true) {
                        int v = in.readInt();
                        ++count;
                    }
                }
                catch (EOFException eOFException) {
                    if (count != LENGTH / 4) {
                        System.out.print("x");
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (in != null) {
                    in.close();
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    static void testLong(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("long");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testWriteLong(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testReadLong(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteLong(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                int length = LENGTH / 8;
                int i = 0;
                while (i < length) {
                    out.writeLong((long)i);
                    ++i;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void testReadLong(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                int count = 0;
                try {
                    while (true) {
                        long v = in.readLong();
                        ++count;
                    }
                }
                catch (EOFException eOFException) {
                    if (count != LENGTH / 8) {
                        System.out.print("x");
                    }
                    if (in != null) {
                        in.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (in != null) {
                    in.close();
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    protected static void testBytes(ArchiveWriter writer, ArchiveReader reader) throws IOException {
        System.out.print("bytes");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testWriteBytes(writer);
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.print("\twrite:" + (end - start));
        start = System.currentTimeMillis();
        i = 0;
        while (i < TEST_COUNT) {
            BufferTest.testReadBytes(reader);
            ++i;
        }
        end = System.currentTimeMillis();
        System.out.println("\tread:" + (end - start));
    }

    static void testWriteBytes(ArchiveWriter writer) throws IOException {
        RAOutputStream out = writer.createOutputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                byte[] data = new byte[8192];
                int length = 0;
                int count = 0;
                while (length < LENGTH) {
                    int size = sizes[count % sizes.length];
                    out.write(data, 0, size);
                    length += size;
                    ++count;
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static void testReadBytes(ArchiveReader reader) throws IOException {
        RAInputStream in = reader.getInputStream(ENTRY_NAME);
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            try {
                byte[] data = new byte[8192];
                int length = 0;
                int count = 0;
                while (length < LENGTH) {
                    int size = sizes[count % sizes.length];
                    in.readFully(data, 0, size);
                    ++count;
                    length += size;
                }
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

