/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.outline;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignVisitor;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.metadata.PropertyDefn;

public class ListenerElementVisitor
extends DesignVisitor {
    private Listener listener;
    private boolean install = true;

    public ListenerElementVisitor(Listener listener) {
        this.listener = listener;
    }

    public void addListener(DesignElementHandle handle) {
        this.install = true;
        this.apply(handle);
    }

    public void removeListener(DesignElementHandle handle) {
        this.install = false;
        this.apply(handle);
    }

    public void visitDesignElement(DesignElementHandle obj) {
        if (this.install) {
            obj.addListener(this.listener);
            if (obj instanceof ReportItemHandle) {
                this.addViewsListener((ReportItemHandle)obj);
            }
        } else {
            obj.removeListener(this.listener);
            if (obj instanceof ReportItemHandle) {
                this.removeViewsListener((ReportItemHandle)obj);
            }
        }
        int i = 0;
        while (i < obj.getDefn().getSlotCount()) {
            this.visitContents(obj.getSlot(i));
            ++i;
        }
        i = 0;
        while (i < obj.getDefn().getContents().size()) {
            this.visitContents(obj, ((PropertyDefn)obj.getDefn().getContents().get(i)).getName());
            ++i;
        }
    }

    private void addViewsListener(ReportItemHandle handle) {
        List views = handle.getViews();
        int i = 0;
        while (i < views.size()) {
            ((DesignElementHandle)views.get(i)).addListener(this.listener);
            ++i;
        }
    }

    private void removeViewsListener(ReportItemHandle handle) {
        List views = handle.getViews();
        int i = 0;
        while (i < views.size()) {
            ((DesignElementHandle)views.get(i)).removeListener(this.listener);
            ++i;
        }
    }

    protected void visitModule(ModuleHandle obj) {
        if (this.listener instanceof IValidationListener) {
            IValidationListener vl = (IValidationListener)this.listener;
            if (this.install) {
                obj.addValidationListener(vl);
            } else {
                obj.removeValidationListener(vl);
            }
        }
        super.visitModule(obj);
    }

    public void dispose() {
        this.listener = null;
    }
}

