/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ingres.internal.ui.sqleditor.texthover;

import org.eclipse.datatools.enablement.ingres.internal.ui.sqleditor.texthover.HoverInfoBuilder;
import org.eclipse.datatools.sqltools.core.DatabaseVendorDefinitionId;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTSQLStatement;
import org.eclipse.datatools.sqltools.sql.parser.ast.IASTStart;
import org.eclipse.datatools.sqltools.sql.parser.ast.Node;
import org.eclipse.datatools.sqltools.sql.parser.ast.SimpleNode;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.sql.AbstractSQLEditorTextHover;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class IngresSQLEditorTextHover
extends AbstractSQLEditorTextHover {
    public static final String VENDOR_INGRES = "INGRES";
    private transient IEditorPart mEditor;

    public void setEditor(IEditorPart editor) {
        this.mEditor = editor;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String result = null;
        if (this.canHandle()) {
            result = HoverInfoBuilder.getHoverInfoString(this.findStatement(this.findNode(hoverRegion.getOffset())));
        }
        return result;
    }

    private boolean canHandle() {
        boolean result = false;
        if (this.mEditor instanceof SQLEditor) {
            ISQLEditorConnectionInfo connInfo = ((SQLEditor)this.mEditor).getConnectionInfo();
            result = this.canHandle(connInfo);
        }
        return result;
    }

    private boolean canHandle(ISQLEditorConnectionInfo connInfo) {
        boolean result = false;
        if (connInfo != null) {
            DatabaseVendorDefinitionId vendorDefId = connInfo.getDatabaseVendorDefinitionId();
            result = this.canHandle(vendorDefId);
        }
        return result;
    }

    private boolean canHandle(DatabaseVendorDefinitionId vendorDefId) {
        boolean result = false;
        if (vendorDefId != null && VENDOR_INGRES.equalsIgnoreCase(vendorDefId.getProductName())) {
            result = true;
        }
        return result;
    }

    private Node findNode(int offset) {
        Node result = null;
        if (this.mEditor instanceof SQLEditor) {
            IDocument document = ((SQLEditor)this.mEditor).getDocumentProvider().getDocument((Object)this.mEditor.getEditorInput());
            if (((SQLEditor)this.mEditor).getParsingResult() != null) {
                IASTStart rootNode = ((SQLEditor)this.mEditor).getParsingResult().getRootNode();
                result = IngresSQLEditorTextHover.findNode(document, offset, (Node)rootNode, true);
            }
        }
        return result;
    }

    private Node findStatement(Node node) {
        if (node == null || node instanceof IASTSQLStatement) {
            return node;
        }
        return this.findStatement(node.jjtGetParent());
    }

    public static Node findNode(IDocument document, int offset, Node rootNode, boolean inclusive) {
        if (!IngresSQLEditorTextHover.contains(document, offset, rootNode, inclusive)) {
            return null;
        }
        SimpleNode root = (SimpleNode)rootNode;
        int i = root.jjtGetNumChildren() - 1;
        while (i >= 0) {
            SimpleNode node = (SimpleNode)root.jjtGetChild(i);
            if (IngresSQLEditorTextHover.contains(document, offset, (Node)node, inclusive)) {
                return IngresSQLEditorTextHover.findNode(document, offset, (Node)node, inclusive);
            }
            --i;
        }
        return root;
    }

    private static boolean contains(IDocument document, int offset, Node node, boolean inclusive) {
        boolean in;
        SimpleNode simpleNode = (SimpleNode)node;
        if (offset > document.getLength()) {
            return false;
        }
        boolean bl = in = simpleNode.getStartOffset(document) <= offset;
        in = inclusive ? in && simpleNode.getGreatestEndOffset(document) >= offset : in && simpleNode.getEndOffset(document) >= offset;
        return in;
    }
}

