/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.wizard.AnnotationsStandaloneGroup;
import org.eclipse.jst.j2ee.internal.wizard.NewJavaClassWizardPage;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.j2ee.project.WebUtilities;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.jst.j2ee.webapplication.JSPType;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebType;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.jst.servlet.ui.internal.navigator.CompressedJavaProject;
import org.eclipse.jst.servlet.ui.internal.plugin.ServletUIPlugin;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public abstract class NewWebClassWizardPage
extends NewJavaClassWizardPage {
    protected AnnotationsStandaloneGroup annotationsGroup;
    protected Button existingClassButton;
    protected Label existingClassLabel;
    protected Text existingClassText;
    protected Button existingButton;

    public NewWebClassWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle, String moduleType) {
        super(model, pageName, pageDesc, pageTitle, moduleType);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = super.createTopLevelComposite(parent);
        this.addSeperator(composite, 3);
        this.createUseExistingGroup(composite);
        this.createAnnotationsGroup(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected IProject getExtendedSelectedProject(Object selection) {
        if (selection instanceof CompressedJavaProject) {
            return ((CompressedJavaProject)selection).getProject().getProject();
        }
        return super.getExtendedSelectedProject(selection);
    }

    protected abstract String getUseExistingCheckboxText();

    protected abstract String getUseExistingProperty();

    protected abstract void handleClassButtonSelected();

    private void createAnnotationsGroup(Composite parent) {
        if (this.isWebDocletProject()) {
            this.annotationsGroup = new AnnotationsStandaloneGroup(parent, (Object)this.model, "jst.ejb".equals(this.projectType), "jst.web".equals(this.projectType));
            if (!this.model.isPropertySet("IArtifactEditOperationDataModelProperties.PROJECT_NAME")) {
                return;
            }
            IProject project = ProjectUtilities.getProject((String)this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME"));
            this.annotationsGroup.setEnablement(project);
        } else {
            this.model.setProperty("IAnnotationsDataModel.useAnnotations", (Object)false);
        }
    }

    private void createUseExistingGroup(Composite composite) {
        this.existingButton = new Button(composite, 32);
        this.existingButton.setText(this.getUseExistingCheckboxText());
        GridData data = new GridData(256);
        data.horizontalSpan = 3;
        this.existingButton.setLayoutData((Object)data);
        this.synchHelper.synchCheckbox(this.existingButton, this.getUseExistingProperty(), null);
        this.existingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebClassWizardPage.this.handleExistingButtonSelected();
            }
        });
        this.existingClassLabel = new Label(composite, 16384);
        this.existingClassLabel.setText(IWebWizardConstants.CLASS_NAME_LABEL);
        this.existingClassLabel.setLayoutData((Object)new GridData(32));
        this.existingClassLabel.setEnabled(false);
        this.existingClassText = new Text(composite, 2060);
        this.existingClassText.setLayoutData((Object)new GridData(768));
        this.existingClassText.setEnabled(false);
        this.synchHelper.synchText(this.existingClassText, "NewJavaClassDataModel.CLASS_NAME", null);
        this.existingClassButton = new Button(composite, 8);
        this.existingClassButton.setText(IWebWizardConstants.BROWSE_BUTTON_LABEL);
        this.existingClassButton.setLayoutData((Object)new GridData(256));
        this.existingClassButton.setEnabled(false);
        this.existingClassButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewWebClassWizardPage.this.handleClassButtonSelected();
            }
        });
    }

    private void handleExistingButtonSelected() {
        boolean enable = this.existingButton.getSelection();
        this.existingClassLabel.setEnabled(enable);
        this.existingClassButton.setEnabled(enable);
        this.packageText.setEnabled(!enable);
        this.packageButton.setEnabled(!enable);
        this.packageLabel.setEnabled(!enable);
        this.classText.setEnabled(!enable);
        this.classLabel.setEnabled(!enable);
        this.superText.setEnabled(!enable);
        this.superButton.setEnabled(!enable);
        this.superLabel.setEnabled(!enable);
    }

    private boolean isWebDocletProject() {
        String projectName = this.model.getStringProperty("IArtifactEditOperationDataModelProperties.PROJECT_NAME");
        if (projectName != null && !"".equals(projectName.trim())) {
            IProject project = ProjectUtilities.getProject((String)projectName);
            try {
                IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                return facetedProject.hasProjectFacet(WebFacetUtils.WEB_XDOCLET_FACET);
            }
            catch (CoreException e) {
                ServletUIPlugin.log((Exception)((Object)e));
            }
        }
        return false;
    }

    protected void validateProjectRequirements(IProject project) {
        if (JavaEEProjectUtilities.isWebFragmentProject((IProject)project)) {
            this.model.setBooleanProperty("INewJavaClassDataModelProperties.GENERATE_DD", Boolean.FALSE.booleanValue());
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null && component.exists()) {
            if (component.getRootFolder() != null && component.getRootFolder().getUnderlyingFolder() != null) {
                IVirtualFile ddXmlFile = component.getRootFolder().getFile((IPath)new Path("WEB-INF/web.xml"));
                if (!ddXmlFile.exists()) {
                    this.model.setBooleanProperty("INewJavaClassDataModelProperties.GENERATE_DD", Boolean.TRUE.booleanValue());
                } else {
                    this.model.setBooleanProperty("INewJavaClassDataModelProperties.GENERATE_DD", Boolean.FALSE.booleanValue());
                }
            }
        } else {
            this.model.setBooleanProperty("INewJavaClassDataModelProperties.GENERATE_DD", Boolean.FALSE.booleanValue());
        }
    }

    protected Object getSelectedObject() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null) {
            return null;
        }
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.size() != 1) {
            return null;
        }
        return ssel.getFirstElement();
    }

    private IType getPrimaryType(ICompilationUnit cu) {
        return cu.getType(new Path(cu.getElementName()).removeFileExtension().toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isObjectSubclassOf(Object obj, String base) {
        IJavaElement jelem = this.getJavaElement(obj);
        try {
            if (jelem == null) return false;
            if (jelem instanceof ICompilationUnit) {
                ICompilationUnit cu = (ICompilationUnit)jelem;
                jelem = this.getPrimaryType(cu);
            }
            if (!(jelem instanceof IType)) return false;
            if (!((IType)jelem).isClass()) return false;
            IType type = (IType)jelem;
            ITypeHierarchy typeHierarchy = type.newTypeHierarchy(null);
            IType[] iTypeArray = typeHierarchy.getAllSuperInterfaces(type);
            int n = iTypeArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IType superType = iTypeArray[n2];
                if (base.equals(superType.getFullyQualifiedName())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            ServletUIPlugin.log((Exception)((Object)e));
        }
        return false;
    }

    protected boolean isServlet(Object obj) {
        if (obj instanceof org.eclipse.jst.javaee.web.Servlet) {
            return true;
        }
        if (obj instanceof Servlet) {
            return true;
        }
        return this.isObjectSubclassOf(obj, "jakarta.servlet.GenericServlet") || this.isObjectSubclassOf(obj, "javax.servlet.GenericServlet");
    }

    protected boolean isFilter(Object obj) {
        if (obj instanceof Filter) {
            return true;
        }
        if (obj instanceof org.eclipse.jst.j2ee.webapplication.Filter) {
            return true;
        }
        return this.isObjectSubclassOf(obj, "jakarta.servlet.Filter") || this.isObjectSubclassOf(obj, "javax.servlet.Filter");
    }

    private String getJavaClass(Object obj) {
        IJavaElement jelem = this.getJavaElement(obj);
        if (jelem == null) {
            throw new IllegalArgumentException("the object parameter must be instance of IJavaElement");
        }
        if (jelem instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)jelem;
            jelem = this.getPrimaryType(cu);
        }
        return ((IType)jelem).getFullyQualifiedName();
    }

    protected String getServletClass(Object obj) {
        if (obj instanceof org.eclipse.jst.javaee.web.Servlet) {
            org.eclipse.jst.javaee.web.Servlet servlet = (org.eclipse.jst.javaee.web.Servlet)obj;
            return servlet.getServletClass();
        }
        if (obj instanceof Servlet) {
            Servlet servlet = (Servlet)obj;
            return servlet.getServletClass().getQualifiedName();
        }
        return this.getJavaClass(obj);
    }

    protected String getFilterClass(Object obj) {
        if (obj instanceof Filter) {
            Filter filter = (Filter)obj;
            return filter.getFilterClass();
        }
        if (obj instanceof org.eclipse.jst.j2ee.webapplication.Filter) {
            org.eclipse.jst.j2ee.webapplication.Filter filter = (org.eclipse.jst.j2ee.webapplication.Filter)obj;
            return filter.getFilterClass().getQualifiedName();
        }
        return this.getJavaClass(obj);
    }

    protected String getServletName(Object obj) {
        block5: {
            Object modelObject;
            String servletClass;
            block4: {
                if (obj instanceof org.eclipse.jst.javaee.web.Servlet) {
                    org.eclipse.jst.javaee.web.Servlet servlet = (org.eclipse.jst.javaee.web.Servlet)obj;
                    return servlet.getServletName();
                }
                if (obj instanceof Servlet) {
                    Servlet servlet = (Servlet)obj;
                    return servlet.getServletName();
                }
                servletClass = this.getServletClass(obj);
                IProject project = this.getJavaElement(obj).getJavaProject().getProject();
                IModelProvider provider = ModelProviderManager.getModelProvider((IProject)project);
                modelObject = provider.getModelObject();
                if (!(modelObject instanceof WebApp)) break block4;
                WebApp webApp = (WebApp)modelObject;
                for (org.eclipse.jst.javaee.web.Servlet servlet : webApp.getServlets()) {
                    String qualified = servlet.getServletClass();
                    if (!qualified.equals(servletClass)) continue;
                    return servlet.getServletName();
                }
                break block5;
            }
            if (!(modelObject instanceof org.eclipse.jst.j2ee.webapplication.WebApp)) break block5;
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)modelObject;
            for (Servlet servlet : webApp.getServlets()) {
                String qualified = servlet.getServletClass().getQualifiedName();
                if (!qualified.equals(servletClass)) continue;
                return servlet.getServletName();
            }
        }
        return null;
    }

    protected boolean isServletJSP(Object obj) {
        return this.getServletJSPFile(obj) != null;
    }

    protected String getServletJSPFile(Object obj) {
        Servlet servlet;
        WebType webType;
        if (obj instanceof org.eclipse.jst.javaee.web.Servlet) {
            org.eclipse.jst.javaee.web.Servlet servlet2 = (org.eclipse.jst.javaee.web.Servlet)obj;
            return servlet2.getJspFile();
        }
        if (obj instanceof Servlet && (webType = (servlet = (Servlet)obj).getWebType()).isJspType()) {
            JSPType jspType = (JSPType)webType;
            return jspType.getJspFile();
        }
        return null;
    }

    protected boolean isWebFolder(Object obj) {
        if (obj instanceof IFolder) {
            return WebUtilities.isWebResource((Object)obj);
        }
        return false;
    }

    protected boolean isJSP(Object obj) {
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            return WebUtilities.isWebResource((Object)file) && file.getName().endsWith(".jsp");
        }
        return false;
    }

    protected String getWebResourcePath(IResource resource) {
        IVirtualComponent comp = ComponentCore.createComponent((IProject)resource.getProject());
        if (comp != null) {
            IPath rootPath = comp.getRootFolder().getWorkspaceRelativePath();
            return "/" + resource.getFullPath().makeRelativeTo(rootPath).toString();
        }
        return null;
    }

    protected String makeFirstCharUppercase(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        StringBuilder builder = new StringBuilder(str);
        builder.setCharAt(0, Character.toUpperCase(builder.charAt(0)));
        return builder.toString();
    }

    protected String getFileNameWithouFileExtension(IFile file) {
        String name = file.getName();
        String ext = file.getFileExtension();
        if (ext == null) {
            return name;
        }
        return name.substring(0, name.length() - (ext.length() + 1));
    }

    protected void checkExistingButton(boolean state) {
        this.existingButton.setSelection(state);
        this.existingButton.notifyListeners(13, new Event());
    }

    protected boolean isProjectValid(IProject project) {
        boolean result;
        if (!project.isAccessible()) {
            return false;
        }
        try {
            IJavaProject javaProject;
            boolean bl = result = project.hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature") && (JavaEEProjectUtilities.isDynamicWebProject((IProject)project) || JavaEEProjectUtilities.isWebFragmentProject((IProject)project));
            if (!result && (javaProject = JavaCore.create((IProject)project)).exists()) {
                result = true;
            }
        }
        catch (CoreException coreException) {
            result = false;
        }
        return result;
    }
}

