/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.activity.subprocess;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.di.BPMNShape;
import org.eclipse.bpmn2.modeler.core.di.DIUtils;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.bpmn2.modeler.ui.ImageProvider;
import org.eclipse.bpmn2.modeler.ui.features.activity.subprocess.Messages;
import org.eclipse.bpmn2.modeler.ui.features.choreography.ShowDiagramPageFeature;
import org.eclipse.graphiti.datatypes.IDimension;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.context.IResizeShapeContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.context.impl.MoveShapeContext;
import org.eclipse.graphiti.features.context.impl.ResizeShapeContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;

public class ExpandFlowNodeFeature
extends ShowDiagramPageFeature {
    private static final String NAME = Messages.ExpandFlowNodeFeature_Name;
    private static final String DESCRIPTION = Messages.ExpandFlowNodeFeature_Description;
    private String name = NAME;
    private String description = DESCRIPTION;
    private boolean hasDoneChanges = false;

    public ExpandFlowNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getImageId() {
        return ImageProvider.IMG_16_EXPAND;
    }

    @Override
    public boolean isAvailable(IContext context) {
        return true;
    }

    @Override
    public boolean canExecute(ICustomContext context) {
        if (super.canExecute(context)) {
            this.name = super.getName();
            this.description = super.getDescription();
            return true;
        }
        this.name = NAME;
        this.description = DESCRIPTION;
        boolean ret = false;
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            BaseElement be = BusinessObjectUtil.getFirstBaseElement((PictogramElement)pes[0]);
            return !FeatureSupport.isElementExpanded((BaseElement)be);
        }
        return ret;
    }

    @Override
    public void execute(ICustomContext context) {
        if (super.canExecute(context)) {
            super.execute(context);
            return;
        }
        PictogramElement[] pes = context.getPictogramElements();
        if (pes != null && pes.length == 1) {
            PictogramElement pe0 = pes[0];
            Object bo = this.getBusinessObjectForPictogramElement(pe0);
            if (pe0 instanceof ContainerShape && bo instanceof FlowNode) {
                ContainerShape containerShape = (ContainerShape)pe0;
                FlowNode flowNode = (FlowNode)bo;
                try {
                    BPMNDiagram bpmnDiagram = DIUtils.findBPMNDiagram((PictogramElement)containerShape);
                    BPMNShape bpmnShape = DIUtils.findBPMNShape((BPMNDiagram)bpmnDiagram, (BaseElement)flowNode);
                    GraphicsAlgorithm ga = containerShape.getGraphicsAlgorithm();
                    FeatureSupport.updateCollapsedSize((ContainerShape)containerShape);
                    IDimension newSize = FeatureSupport.getExpandedSize((ContainerShape)containerShape);
                    int newWidth = newSize.getWidth();
                    int newHeight = newSize.getHeight();
                    int oldWidth = ga.getWidth();
                    int oldHeight = ga.getHeight();
                    ResizeShapeContext resizeContext = new ResizeShapeContext((Shape)containerShape);
                    resizeContext.setWidth(newWidth);
                    resizeContext.setHeight(newHeight);
                    int newX = ga.getX() + oldWidth / 2 - newWidth / 2;
                    int newY = ga.getY() + oldHeight / 2 - newHeight / 2;
                    resizeContext.setX(newX);
                    resizeContext.setY(newY);
                    resizeContext.setWidth(newWidth);
                    resizeContext.setHeight(newHeight);
                    FeatureSupport.setElementExpanded((PictogramElement)containerShape, (boolean)true);
                    IResizeShapeFeature resizeFeature = this.getFeatureProvider().getResizeShapeFeature((IResizeShapeContext)resizeContext);
                    resizeFeature.resizeShape((IResizeShapeContext)resizeContext);
                    bpmnShape.setIsExpanded(true);
                    newWidth = resizeContext.getWidth();
                    newHeight = resizeContext.getHeight();
                    if (newX != ga.getX() || newY != ga.getY()) {
                        MoveShapeContext moveContext = new MoveShapeContext((Shape)containerShape);
                        moveContext.setDeltaX(oldWidth / 2 - newWidth / 2);
                        moveContext.setDeltaY(oldHeight / 2 - newHeight / 2);
                        moveContext.setSourceContainer(containerShape.getContainer());
                        moveContext.setTargetContainer(containerShape.getContainer());
                        moveContext.setLocation(newX, newY);
                        IMoveShapeFeature moveFeature = this.getFeatureProvider().getMoveShapeFeature((IMoveShapeContext)moveContext);
                        moveFeature.moveShape((IMoveShapeContext)moveContext);
                    }
                    UpdateContext updateContext = new UpdateContext((PictogramElement)containerShape);
                    updateContext.putProperty((Object)"force.update.all", (Object)Boolean.TRUE);
                    IUpdateFeature updateFeature = this.getFeatureProvider().getUpdateFeature((IUpdateContext)updateContext);
                    updateFeature.update((IUpdateContext)updateContext);
                    LayoutContext layoutContext = new LayoutContext((PictogramElement)containerShape);
                    this.getFeatureProvider().layoutIfPossible((ILayoutContext)layoutContext);
                    ArrayList<ContainerShape> children = new ArrayList<ContainerShape>();
                    for (PictogramElement pe : containerShape.getChildren()) {
                        if (!(pe instanceof ContainerShape) || !FeatureSupport.hasBPMNShape((PictogramElement)pe)) continue;
                        children.add((ContainerShape)pe);
                    }
                    for (ContainerShape s : children) {
                        layoutContext = new LayoutContext((PictogramElement)s);
                        this.getFeatureProvider().layoutIfPossible((ILayoutContext)layoutContext);
                    }
                    FeatureSupport.updateConnections((IFeatureProvider)this.getFeatureProvider(), (List)FeatureSupport.getConnections((AnchorContainer)containerShape), (boolean)true);
                    this.hasDoneChanges = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public boolean hasDoneChanges() {
        return this.hasDoneChanges;
    }
}

