/*******************************************************************************
 * Copyright (c) 2011, 2012, 2013, 2014 Red Hat, Inc.
 *  All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Red Hat, Inc. - initial API and implementation
 *
 * @author Bob Brodt
 ******************************************************************************/

package org.eclipse.bpmn2.modeler.core.validation.validators;

import org.eclipse.bpmn2.ChoreographyTask;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.validation.IValidationContext;

/**
 *
 */
public class ChoreographyTaskValidator extends AbstractBpmn2ElementValidator<ChoreographyTask> {

	/**
	 * Construct a BPMN2 Element Validator from a Validation Context.
	 *
	 * @param ctx
	 */
	public ChoreographyTaskValidator(IValidationContext ctx) {
		super(ctx);
	}

	/**
	 * Construct a BPMN2 Element Validator with the given Validator as the parent.
	 * The parent is responsible for collecting all of the validation Status objects
	 * and reporting them back to the Validation Constraint.
	 *
	 * @param parent a parent Validator class
	 */
	@SuppressWarnings("rawtypes")
	public ChoreographyTaskValidator(AbstractBpmn2ElementValidator parent) {
		super(parent);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator#validate(org.eclipse.bpmn2.BaseElement)
	 */
	@Override
	public IStatus validate(ChoreographyTask object) {
		for (MessageFlow mf : object.getMessageFlowRef()) {
			InteractionNode in = mf.getSourceRef();
			if (!object.getParticipantRefs().contains(in)) {
				addStatus(object,"participantRefs",Status.ERROR,org.eclipse.bpmn2.modeler.core.validation.validators.Messages.ChoreographyTaskValidator_Source_Not_Participant); //$NON-NLS-1$
			}
			in = mf.getTargetRef();
			if (!object.getParticipantRefs().contains(in)) {
				addStatus(object,"participantRefs",Status.ERROR,org.eclipse.bpmn2.modeler.core.validation.validators.Messages.ChoreographyTaskValidator_Target_Not_Participant); //$NON-NLS-1$
			}
		}
		return getResult();
	}

}

