/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.repository.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeBasedTable;
import com.gradleware.tooling.toolingmodel.OmniBuildInvocations;
import com.gradleware.tooling.toolingmodel.OmniProjectTask;
import com.gradleware.tooling.toolingmodel.OmniTaskSelector;
import com.gradleware.tooling.toolingmodel.Path;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocations;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniBuildInvocationsContainer;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniProjectTask;
import com.gradleware.tooling.toolingmodel.repository.internal.DefaultOmniTaskSelector;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.GradleTask;
import org.gradle.tooling.model.Task;

public final class DefaultOmniBuildInvocationsContainerBuilder {
    public static DefaultOmniBuildInvocationsContainer build(GradleProject project) {
        ImmutableMultimap<Path, OmniProjectTask> tasks = DefaultOmniBuildInvocationsContainerBuilder.getAllProjectTasksByProjectPath(project);
        ImmutableMultimap<Path, OmniTaskSelector> taskSelectors = DefaultOmniBuildInvocationsContainerBuilder.getAllTaskSelectorsByProjectPath(project);
        ImmutableSortedMap<Path, OmniBuildInvocations> buildInvocationsPerProject = DefaultOmniBuildInvocationsContainerBuilder.buildBuildInvocationsMapping(project, tasks, taskSelectors);
        return DefaultOmniBuildInvocationsContainer.from(buildInvocationsPerProject);
    }

    private static ImmutableSortedMap<Path, OmniBuildInvocations> buildBuildInvocationsMapping(GradleProject project, Multimap<Path, OmniProjectTask> projectTasks, Multimap<Path, OmniTaskSelector> taskSelectors) {
        Preconditions.checkState((boolean)taskSelectors.keySet().containsAll(projectTasks.keySet()), (Object)"Task selectors are always configured for all projects");
        ImmutableSortedMap.Builder mapping = ImmutableSortedMap.orderedBy((Comparator)Path.Comparator.INSTANCE);
        for (Path projectPath : taskSelectors.keySet()) {
            ImmutableList projectTasksOfProject = ImmutableSortedSet.orderedBy((Comparator)TaskComparator.INSTANCE).addAll((Iterable)projectTasks.get((Object)projectPath)).build().asList();
            ImmutableList taskSelectorsOfProject = ImmutableSortedSet.orderedBy((Comparator)TaskSelectorComparator.INSTANCE).addAll((Iterable)taskSelectors.get((Object)projectPath)).build().asList();
            mapping.put((Object)projectPath, (Object)DefaultOmniBuildInvocations.from((List<OmniProjectTask>)projectTasksOfProject, (List<OmniTaskSelector>)taskSelectorsOfProject));
        }
        Sets.SetView projectsWithoutTaskSelectors = Sets.difference(DefaultOmniBuildInvocationsContainerBuilder.getAllProjectPaths(project), (Set)taskSelectors.keySet());
        for (Path projectPath : projectsWithoutTaskSelectors) {
            mapping.put((Object)projectPath, (Object)DefaultOmniBuildInvocations.from((List<OmniProjectTask>)ImmutableList.of(), (List<OmniTaskSelector>)ImmutableList.of()));
        }
        return mapping.build();
    }

    private static ImmutableSet<Path> getAllProjectPaths(GradleProject project) {
        ImmutableSet.Builder projectPaths = ImmutableSet.builder();
        projectPaths.add((Object)Path.from(project.getPath()));
        for (GradleProject childProject : project.getChildren()) {
            projectPaths.addAll(DefaultOmniBuildInvocationsContainerBuilder.getAllProjectPaths(childProject));
        }
        return projectPaths.build();
    }

    private static ImmutableMultimap<Path, OmniProjectTask> getAllProjectTasksByProjectPath(GradleProject project) {
        ImmutableMultimap.Builder tasks = ImmutableMultimap.builder();
        for (GradleTask task : project.getTasks()) {
            tasks.put((Object)Path.from(project.getPath()), (Object)DefaultOmniProjectTask.from((Task)task));
        }
        for (GradleProject child : project.getChildren()) {
            tasks.putAll(DefaultOmniBuildInvocationsContainerBuilder.getAllProjectTasksByProjectPath(child));
        }
        return tasks.build();
    }

    private static ImmutableMultimap<Path, OmniTaskSelector> getAllTaskSelectorsByProjectPath(GradleProject project) {
        ImmutableMultimap.Builder taskSelectors = ImmutableMultimap.builder();
        TreeBasedTable<String, Path, OmniProjectTask> tasksByNameAndPath = DefaultOmniBuildInvocationsContainerBuilder.getAllProjectTasksByNameAndPath(project);
        for (String selectorName : tasksByNameAndPath.rowKeySet()) {
            SortedMap tasksByPath = tasksByNameAndPath.row((Object)selectorName);
            OmniProjectTask taskWithShortestPath = (OmniProjectTask)tasksByPath.get(tasksByPath.firstKey());
            boolean isPublic = Iterables.any(tasksByPath.values(), (Predicate)new Predicate<OmniProjectTask>(){

                public boolean apply(OmniProjectTask input) {
                    return input.isPublic();
                }
            });
            ImmutableSortedSet selectedPaths = ImmutableSortedSet.copyOf(tasksByPath.comparator(), tasksByPath.keySet());
            DefaultOmniTaskSelector taskSelector = DefaultOmniTaskSelector.from(selectorName, taskWithShortestPath.getDescription(), Path.from(project.getPath()), isPublic, taskWithShortestPath.getGroup(), (SortedSet<Path>)selectedPaths);
            taskSelectors.put((Object)Path.from(project.getPath()), (Object)taskSelector);
        }
        for (GradleProject childProject : project.getChildren()) {
            taskSelectors.putAll(DefaultOmniBuildInvocationsContainerBuilder.getAllTaskSelectorsByProjectPath(childProject));
        }
        return taskSelectors.build();
    }

    private static TreeBasedTable<String, Path, OmniProjectTask> getAllProjectTasksByNameAndPath(GradleProject project) {
        TreeBasedTable tasks = TreeBasedTable.create((Comparator)Ordering.natural(), (Comparator)Path.Comparator.INSTANCE);
        for (GradleTask task : project.getTasks()) {
            DefaultOmniProjectTask projectTask = DefaultOmniProjectTask.from((Task)task);
            tasks.put((Object)projectTask.getName(), (Object)projectTask.getPath(), (Object)projectTask);
        }
        for (GradleProject childProject : project.getChildren()) {
            tasks.putAll(DefaultOmniBuildInvocationsContainerBuilder.getAllProjectTasksByNameAndPath(childProject));
        }
        return tasks;
    }

    private static enum TaskComparator implements Comparator<OmniProjectTask>
    {
        INSTANCE;


        @Override
        public int compare(OmniProjectTask o1, OmniProjectTask o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private static enum TaskSelectorComparator implements Comparator<OmniTaskSelector>
    {
        INSTANCE;


        @Override
        public int compare(OmniTaskSelector o1, OmniTaskSelector o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

