/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.gradle.api.Nullable;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.CompositeStoppable;

public abstract class ClassLoaderUtils {
    public static ClassLoader getPlatformClassLoader() {
        return ClassLoader.getSystemClassLoader().getParent();
    }

    public static void tryClose(@Nullable ClassLoader classLoader) {
        CompositeStoppable.stoppable(classLoader).stop();
    }

    public static void disableUrlConnectionCaching() {
        try {
            URL url = new URL("jar:file://valid_jar_url_syntax.jar!/");
            URLConnection urlConnection = url.openConnection();
            urlConnection.setDefaultUseCaches(false);
        }
        catch (MalformedURLException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }
}

