/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.ui;

import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.ui.diffuidata.ComparisonSelection;
import org.eclipse.emf.diffmerge.ui.setup.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.diffmerge.defer.ui.DeferComparisonJob;
import org.polarsys.capella.diffmerge.defer.ui.EMFDiffMergeDeferUIPlugin;
import org.polarsys.capella.diffmerge.defer.ui.messages.Messages;
import org.polarsys.capella.diffmerge.defer.ui.views.PendingChangesViewUtil;

public class DeferComparisonHandler
extends AbstractHandler {
    public static final String DEFER_MERGE_LABEL = Messages.DeferChangesHandler_Header;
    protected static final Role TARGET_ROLE = Role.TARGET;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EMFDiffNode node;
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (shell != null && (node = this.getDiffNode(event)) != null) {
            this.execute(node, shell);
        }
        return null;
    }

    protected void execute(EMFDiffNode node, Shell shell) {
        URI deferFileURI = this.getDeferFileURI(node, shell);
        if (deferFileURI != null) {
            DeferComparisonJob deferJob = new DeferComparisonJob(node, deferFileURI);
            deferJob.schedule();
        }
    }

    public URI getDeferFileURI(EMFDiffNode node, Shell shell) {
        IFile changeFile;
        boolean confirmed;
        Resource mainResource;
        URI result = null;
        URI targetScopeURI = null;
        IEditableTreeDataScope targetScope = node.getUIComparison().getActualComparison().getScope(TARGET_ROLE);
        if (targetScope instanceof IPersistentModelScope && (mainResource = ((IPersistentModelScope)targetScope).getHoldingResource()) != null) {
            targetScopeURI = mainResource.getURI();
        }
        String fileExt = EMFDiffMergeDeferUIPlugin.getDefault().getFileExtension();
        URI proposedURI = targetScopeURI == null || !targetScopeURI.isPlatformResource() ? null : targetScopeURI.trimFileExtension().appendFileExtension(fileExt);
        IPath proposedPath = proposedURI == null ? null : PendingChangesViewUtil.getAutoNewNameFor((IPath)new Path(proposedURI.toPlatformString(true)), ResourcesPlugin.getWorkspace());
        do {
            confirmed = true;
            changeFile = WorkspaceResourceDialog.openNewFile((Shell)shell, (String)DEFER_MERGE_LABEL, (String)Messages.DeferChangesHandler_DefineFileDescription, (IPath)proposedPath, Collections.emptyList());
            if (changeFile == null || !changeFile.exists() || (confirmed = MessageDialog.openQuestion((Shell)shell, (String)DEFER_MERGE_LABEL, (String)Messages.DeferComparisonHandler_FileOverwrite))) continue;
            proposedPath = changeFile.getFullPath();
        } while (!confirmed);
        if (changeFile != null) {
            result = URI.createPlatformResourceURI((String)changeFile.getFullPath().toString(), (boolean)true);
        }
        return result;
    }

    protected EMFDiffNode getDiffNode(ExecutionEvent event) {
        IEditorInput input;
        EMFDiffNode result = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ComparisonSelection) {
            result = ((ComparisonSelection)selection).getDiffNode();
        }
        if (result == null && (input = HandlerUtil.getActiveEditorInput((ExecutionEvent)event)) instanceof EMFDiffMergeEditorInput) {
            result = ((EMFDiffMergeEditorInput)input).getCompareResult();
        }
        return result;
    }
}

