/*
 * Copyright (c) 2022 The Bank of New York Mellon.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;

import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableFloatIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableFloatSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

/**
 * A boxed view of a {@link MutableFloatSet}.
 *
 * This is for scenarios where optimization is not a consideration and therefore no further methods will be optimized.
 * <p>
 * This file was automatically generated from template file  boxedPrimitiveSet.stg.
 *
 * @since 12.0
 */
public class BoxedMutableFloatSet extends AbstractMutableSet<Float>
        implements MutableSet<Float>
{
    private final MutableFloatSet delegate;

    public BoxedMutableFloatSet(MutableFloatSet delegate)
    {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size()
    {
        return this.delegate.size();
    }

    @Override
    public Float getFirst()
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float getLast()
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public void each(Procedure<? super Float> procedure)
    {
        this.delegate.each(procedure::value);
    }

    @Override
    public boolean add(Float item)
    {
        return this.delegate.add(item.floatValue());
    }

    @Override
    public boolean contains(Object object)
    {
        return object instanceof Float && this.delegate.contains(((Float) object).floatValue());
    }

    @Override
    public boolean remove(Object object)
    {
        return object instanceof Float && this.delegate.remove(((Float) object).floatValue());
    }

    @Override
    public void clear()
    {
        this.delegate.clear();
    }

    @Override
    public ParallelUnsortedSetIterable<Float> asParallel(ExecutorService executorService, int batchSize)
    {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode()
    {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }

        if (!(object instanceof Set))
        {
            return false;
        }

        Set<?> other = (Set<?>) object;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public Iterator<Float> iterator()
    {
        return new BoxedPrimitiveFloatSetIterator(this.delegate.floatIterator());
    }

    private static final class BoxedPrimitiveFloatSetIterator implements Iterator<Float>
    {
        private final MutableFloatIterator delegate;

        private BoxedPrimitiveFloatSetIterator(MutableFloatIterator iterator)
        {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext()
        {
            return this.delegate.hasNext();
        }

        @Override
        public Float next()
        {
            return this.delegate.next();
        }
    }
}
