/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableIntList
extends AbstractMutableList<Integer>
implements MutableList<Integer>,
RandomAccess {
    private final MutableIntList delegate;

    public BoxedMutableIntList(MutableIntList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Integer item) {
        return this.delegate.add(item);
    }

    @Override
    public boolean addAll(int index, Collection<? extends Integer> c) {
        int[] target = new int[c.size()];
        Iterate.forEachWithIndex(c, (each, parameter) -> {
            target[parameter] = each;
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Integer get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public Integer set(int index, Integer element) {
        return this.delegate.set(index, element);
    }

    @Override
    public void add(int index, Integer element) {
        this.delegate.addAtIndex(index, element);
    }

    @Override
    public Integer remove(int index) {
        return this.delegate.removeAtIndex(index);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Integer ? this.delegate.indexOf((Integer)o) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Integer ? this.delegate.lastIndexOf((Integer)o) : -1;
    }

    @Override
    public MutableList<Integer> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

