/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableShortIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableShortSet
extends AbstractMutableSet<Short>
implements MutableSet<Short> {
    private final MutableShortSet delegate;

    public BoxedMutableShortSet(MutableShortSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public Short getFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Short getLast() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void each(Procedure<? super Short> procedure) {
        this.delegate.each(procedure::value);
    }

    @Override
    public boolean add(Short item) {
        return this.delegate.add(item);
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Short && this.delegate.contains((Short)object);
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Short && this.delegate.remove((Short)object);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public ParallelUnsortedSetIterable<Short> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    @Override
    public Iterator<Short> iterator() {
        return new BoxedPrimitiveShortSetIterator(this.delegate.shortIterator());
    }

    private static final class BoxedPrimitiveShortSetIterator
    implements Iterator<Short> {
        private final MutableShortIterator delegate;

        private BoxedPrimitiveShortSetIterator(MutableShortIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Short next() {
            return this.delegate.next();
        }
    }
}

