/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.CharPredicate;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.CharSet;
import org.eclipse.collections.api.set.primitive.ImmutableCharSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.tuple.primitive.CharCharPair;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractSynchronizedCharCollection;
import org.eclipse.collections.impl.factory.primitive.CharSets;
import org.eclipse.collections.impl.lazy.primitive.LazyCharIterableAdapter;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.set.mutable.primitive.BoxedMutableCharSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableCharSet;

public class SynchronizedCharSet
extends AbstractSynchronizedCharCollection
implements MutableCharSet {
    private static final long serialVersionUID = 1L;

    public SynchronizedCharSet(MutableCharSet set) {
        super(set);
    }

    public SynchronizedCharSet(MutableCharSet set, Object newLock) {
        super(set, newLock);
    }

    public static SynchronizedCharSet of(MutableCharSet set) {
        return new SynchronizedCharSet(set);
    }

    public static SynchronizedCharSet of(MutableCharSet set, Object lock) {
        return new SynchronizedCharSet(set, lock);
    }

    private MutableCharSet getMutableCharSet() {
        return (MutableCharSet)this.getCharCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet without(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().remove(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableSet<Character> boxed() {
        Object object = this.getLock();
        synchronized (object) {
            return SynchronizedMutableSet.of(new BoxedMutableCharSet(this), this.getLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet with(char element) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().add(element);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet withAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().addAll(elements.toArray());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SynchronizedCharSet withoutAll(CharIterable elements) {
        Object object = this.getLock();
        synchronized (object) {
            this.getMutableCharSet().removeAll(elements);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet select(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet reject(CharPredicate predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> MutableSet<V> collect(CharToObjectFunction<? extends V> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().collect((CharToObjectFunction)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyIterable<CharCharPair> cartesianProduct(CharSet set) {
        Object object = this.getLock();
        synchronized (object) {
            return CharSets.cartesianProduct(this, set);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object otherSet) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().equals(otherSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyCharIterable asLazy() {
        Object object = this.getLock();
        synchronized (object) {
            return new LazyCharIterableAdapter(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet asUnmodifiable() {
        Object object = this.getLock();
        synchronized (object) {
            return new UnmodifiableCharSet(this);
        }
    }

    @Override
    public MutableCharSet asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSet freeze() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().freeze();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableCharSet toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableCharSet newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getMutableCharSet().newEmpty();
        }
    }
}

