/*
 * Copyright (c) 2017 Goldman Sachs.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.ordered.primitive;

import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.block.function.primitive.BooleanToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.ordered.ReversibleIterable;

/**
 * This file was automatically generated from template file reversiblePrimitiveIterable.stg.
 *
 * @since 5.0.
 */
public interface ReversibleBooleanIterable extends OrderedBooleanIterable
{
    boolean getLast();

    LazyBooleanIterable asReversed();

    @Override
    ReversibleBooleanIterable select(BooleanPredicate predicate);

    @Override
    ReversibleBooleanIterable reject(BooleanPredicate predicate);

    @Override
    <V> ReversibleIterable<V> collect(BooleanToObjectFunction<? extends V> function);

    ReversibleBooleanIterable toReversed();

    /**
     * @since 6.0.
     */
    ReversibleBooleanIterable distinct();

    @Override
    <T> T injectIntoWithIndex(T injectedValue, ObjectBooleanIntToObjectFunction<? super T, ? extends T> function);
}
