/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.project.generatortasks;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.project.project.CodeGenerationSource;
import org.eclipse.comma.project.project.DocumentationGenerationTask;
import org.eclipse.comma.project.project.DocumentationSource;
import org.eclipse.comma.project.project.FilePath;
import org.eclipse.comma.project.project.InterfaceReference;
import org.eclipse.comma.project.project.MonitoringTask;
import org.eclipse.comma.project.project.Task;
import org.eclipse.comma.project.project.TraceSource;
import org.eclipse.comma.project.project.UMLTask;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.AbstractFileSystemAccess2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.OutputConfiguration;

public class OutputLocator {
    public static final String DEFAULT_OUTPUT_FOLDER = "src-gen/";
    public static final String COMMA_GEN_FOLDER = "../../../comma-gen/";
    public static final String DOC_FOLDER = "doc/";
    public static final String DOC_EXT = ".docx";
    public static final String JAVA_FOLDER = "java/";
    public static final String TRACE_FOLDER = "traces";
    public static final String MONITORING_FILENAME = "ScenarioPlayer.java";

    public String getGeneratedFile(Task task) {
        String _outputFolder = this.getOutputFolder(task);
        String _fileName = this.getFileName(task);
        return String.valueOf(_outputFolder) + _fileName;
    }

    protected String _getOutputFolder(DocumentationGenerationTask task) {
        return DOC_FOLDER;
    }

    protected String _getOutputFolder(UMLTask task) {
        String _name = task.getName();
        String _plus = "uml/" + _name;
        return String.valueOf(_plus) + Character.valueOf('/');
    }

    protected String _getFileName(DocumentationGenerationTask task) {
        String _name = task.getName();
        return String.valueOf(_name) + DOC_EXT;
    }

    protected String _getFileName(MonitoringTask task) {
        return "Dummy";
    }

    public Resource getTraceResource(IFileSystemAccess access, TraceSource source) {
        return EcoreUtil2.getResource((Resource)source.eResource(), (String)((FilePath)source).getPath());
    }

    public URI getTraceResourceURI(IFileSystemAccess fsa, TraceSource source) {
        return URI.createURI((String)((FilePath)source).getPath()).resolve(source.eResource().getURI());
    }

    public String getDefaultOutputFolder(IFileSystemAccess fsa) {
        if (fsa instanceof AbstractFileSystemAccess2) {
            ((OutputConfiguration)((AbstractFileSystemAccess2)fsa).getOutputConfigurations().get("DEFAULT_OUTPUT")).getOutputDirectory();
        }
        return DEFAULT_OUTPUT_FOLDER;
    }

    protected ArrayList<Interface> _getInterfaces(CodeGenerationSource source) {
        return new ArrayList<Interface>();
    }

    protected ArrayList<Interface> _getInterfaces(DocumentationSource source) {
        return new ArrayList<Interface>();
    }

    protected ArrayList<Interface> _getInterfaces(InterfaceReference source) {
        ArrayList<Interface> _xblockexpression = null;
        ArrayList<Interface> result = new ArrayList<Interface>();
        result.add(source.getInterface());
        _xblockexpression = result;
        return _xblockexpression;
    }

    public String getOutputFolder(Task task) {
        if (task instanceof DocumentationGenerationTask) {
            return this._getOutputFolder((DocumentationGenerationTask)task);
        }
        if (task instanceof UMLTask) {
            return this._getOutputFolder((UMLTask)task);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task).toString());
    }

    public String getFileName(Task task) {
        if (task instanceof DocumentationGenerationTask) {
            return this._getFileName((DocumentationGenerationTask)task);
        }
        if (task instanceof MonitoringTask) {
            return this._getFileName((MonitoringTask)task);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(task).toString());
    }

    public ArrayList<Interface> getInterfaces(EObject source) {
        if (source instanceof InterfaceReference) {
            return this._getInterfaces((InterfaceReference)source);
        }
        if (source instanceof CodeGenerationSource) {
            return this._getInterfaces((CodeGenerationSource)source);
        }
        if (source instanceof DocumentationSource) {
            return this._getInterfaces((DocumentationSource)source);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(source).toString());
    }
}

