/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.HashMap;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.commands.CommandCopyFilter;
import org.eclipse.pde.internal.ui.commands.CommandDetails;
import org.eclipse.pde.internal.ui.commands.CommandList;
import org.eclipse.pde.internal.ui.commands.TagManager;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class CommandComposerPart
implements ISelectionChangedListener {
    public static final int F_FILTER_NOT_SET = CommandCopyFilter.indexOf(CommandCopyFilter.NONE);
    public static final int F_HELP_FILTER = CommandCopyFilter.indexOf(CommandCopyFilter.HELP);
    public static final int F_CHEATSHEET_FILTER = CommandCopyFilter.indexOf(CommandCopyFilter.CHEATSHEET);
    public static final int F_INTRO_FILTER = CommandCopyFilter.indexOf(CommandCopyFilter.INTRO);
    private static final ICommandService fCommandService = CommandComposerPart.initCommandService();
    private final TagManager fTagManager = new TagManager();
    private FormToolkit fToolkit;
    private ScrolledForm fScrolledForm;
    private CommandList fCommandList;
    private CommandDetails fCommandDetails;
    private int fFilterType = F_FILTER_NOT_SET;
    private ParameterizedCommand fPC;
    private Image fCommandImage;
    private IEvaluationContext fSnapshotContext;

    private static ICommandService initCommandService() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Object serviceObject = workbench.getAdapter(ICommandService.class);
        if (serviceObject instanceof ICommandService) {
            return (ICommandService)serviceObject;
        }
        return null;
    }

    public void setFilterType(int filterType) {
        this.fFilterType = filterType;
    }

    public int getFilterType() {
        return this.fFilterType;
    }

    public void setSnapshotContext(IEvaluationContext context) {
        this.fSnapshotContext = context;
    }

    public IEvaluationContext getSnapshotContext() {
        return this.fSnapshotContext;
    }

    protected void createCC(ScrolledForm form, FormToolkit toolkit, ISelectionChangedListener listener) {
        this.fToolkit = toolkit;
        this.fScrolledForm = form;
        this.fScrolledForm.setText(PDEUIMessages.CommandComposerPart_formTitle);
        this.fCommandImage = PDEPluginImages.DESC_BUILD_VAR_OBJ.createImage();
        this.fScrolledForm.setImage(this.fCommandImage);
        Composite body = this.fScrolledForm.getBody();
        GridLayout layout = new GridLayout();
        layout.marginTop = 10;
        body.setLayout((Layout)layout);
        body.setLayoutData((Object)new GridData(1808));
        SashForm sashForm = new SashForm(body, 256);
        sashForm.setLayoutData((Object)new GridData(1808));
        this.fCommandList = new CommandList(this, (Composite)sashForm);
        if (listener != null) {
            this.fCommandList.addTreeSelectionListener(listener);
        }
        this.fCommandDetails = new CommandDetails(this, (Composite)sashForm);
        sashForm.setWeights(new int[]{4, 5});
        this.fToolkit.adapt((Control)sashForm, true, true);
        if (this.fPC != null) {
            this.fCommandList.setSelection(this.fPC.getCommand());
        }
        this.fPC = null;
    }

    protected void setMessage(String message, int newType) {
        this.fScrolledForm.getForm().setMessage(message, newType);
    }

    public FormToolkit getToolkit() {
        return this.fToolkit;
    }

    public ICommandService getCommandService() {
        return fCommandService;
    }

    public TagManager getTagManager() {
        return this.fTagManager;
    }

    public void setFocus() {
        this.fCommandList.setFocus();
    }

    public void dispose() {
        this.fCommandDetails.dispose();
        if (this.fCommandImage != null) {
            this.fCommandImage.dispose();
            this.fCommandImage = null;
        }
    }

    protected String getSelectedCommandName() {
        return this.fCommandDetails.getCommandName();
    }

    protected String getSelectedSerializedString() {
        return this.fCommandDetails.getSerializedString();
    }

    protected HashMap<?, ?> getSelectedCommandsParameters() {
        return this.fCommandDetails.getParameters();
    }

    protected Composite createComposite(Composite parent) {
        return this.createComposite(parent, 1808, 1, true, 0);
    }

    protected Composite createComposite(Composite parent, int gdStyle, int numCol, boolean colEqual, int margin) {
        Composite comp = this.fToolkit.createComposite(parent);
        GridLayout layout = new GridLayout(numCol, colEqual);
        layout.marginHeight = layout.marginWidth = margin;
        comp.setLayout((Layout)layout);
        comp.setLayoutData((Object)new GridData(gdStyle));
        return comp;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setMessage(null, 0);
        Object selectionObject = null;
        if (this.fPC != null) {
            selectionObject = this.fPC;
        } else if (event.getSelection() instanceof IStructuredSelection) {
            selectionObject = event.getStructuredSelection().getFirstElement();
        }
        if (selectionObject != null && selectionObject.equals(this.fCommandDetails.getCommand())) {
            return;
        }
        this.fCommandDetails.showDetailsFor(selectionObject);
    }

    public ParameterizedCommand getParameterizedCommand() {
        return this.fCommandDetails.buildParameterizedCommand();
    }

    protected void setPresetCommand(ParameterizedCommand pc) {
        this.fPC = pc;
    }

    protected ParameterizedCommand getPresetCommand() {
        return this.fPC;
    }

    public CommandList getCommandList() {
        return this.fCommandList;
    }
}

