/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.util;

import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.AbstractInformationControlManager;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.IInformationProviderExtension;
import org.eclipse.jface.text.information.IInformationProviderExtension2;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.internal.wikitext.ui.editor.syntax.FastMarkupPartitioner;
import org.eclipse.mylyn.wikitext.ui.viewer.HtmlTextPresenter;
import org.eclipse.swt.custom.StyledText;

public class InformationPresenterUtil {
    private static final String DATA_INFORMATION_PRESENTER = String.valueOf(InformationPresenterUtil.class.getName()) + "#informationPresenter";
    private static final String DATA_INFORMATION_CONTROL_CREATOR = String.valueOf(InformationPresenterUtil.class.getName()) + "#informationControlCreator";

    public static InformationPresenter getHtmlInformationPresenter(ISourceViewer viewer, SizeConstraint constraint, ToolBarManager toolBarManager, String htmlContent) {
        IInformationControlCreator informationControlCreator;
        StyledText control = viewer.getTextWidget();
        InformationPresenter presenter = (InformationPresenter)control.getData(DATA_INFORMATION_PRESENTER);
        int offset = viewer.getSelectedRange().x;
        if (presenter == null) {
            informationControlCreator = shell -> new DefaultInformationControl(shell, toolBarManager, (DefaultInformationControl.IInformationPresenter)new HtmlTextPresenter());
            presenter = new InformationPresenter(informationControlCreator){

                public IInformationProvider getInformationProvider(String contentType) {
                    IInformationProvider informationProvider = super.getInformationProvider(contentType);
                    if (informationProvider == null) {
                        informationProvider = super.getInformationProvider("__dftl_partition_content_type");
                    }
                    return informationProvider;
                }
            };
            presenter.install((ITextViewer)viewer);
            presenter.setAnchor(AbstractInformationControlManager.ANCHOR_BOTTOM);
            presenter.setMargins(6, 6);
            presenter.setOffset(offset);
            presenter.install((ITextViewer)viewer);
            InformationPresenter informationPresenter = presenter;
            viewer.getTextWidget().addDisposeListener(e -> {
                try {
                    informationPresenter.uninstall();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                informationPresenter.dispose();
            });
            control.setData(DATA_INFORMATION_PRESENTER, (Object)presenter);
            control.setData(DATA_INFORMATION_CONTROL_CREATOR, (Object)informationControlCreator);
        } else {
            informationControlCreator = (IInformationControlCreator)control.getData(DATA_INFORMATION_CONTROL_CREATOR);
            presenter.disposeInformationControl();
        }
        presenter.setSizeConstraints(constraint.horizontalWidthInChars, constraint.verticalWidthInChars, constraint.enforceAsMinimumSize, constraint.enforceAsMaximumSize);
        InformationProvider informationProvider = new InformationProvider((IRegion)new Region(offset, 0), htmlContent, informationControlCreator);
        String[] stringArray = FastMarkupPartitioner.ALL_CONTENT_TYPES;
        int n = FastMarkupPartitioner.ALL_CONTENT_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String contentType = stringArray[n2];
            presenter.setInformationProvider((IInformationProvider)informationProvider, contentType);
            ++n2;
        }
        presenter.setInformationProvider((IInformationProvider)informationProvider, "__dftl_partition_content_type");
        return presenter;
    }

    private static final class InformationProvider
    implements IInformationProvider,
    IInformationProviderExtension,
    IInformationProviderExtension2 {
        private final IRegion hoverRegion;
        private final Object hoverInfo;
        private final IInformationControlCreator controlCreator;

        InformationProvider(IRegion hoverRegion, Object info, IInformationControlCreator controlCreator) {
            this.hoverRegion = hoverRegion;
            this.hoverInfo = info;
            this.controlCreator = controlCreator;
        }

        public IRegion getSubject(ITextViewer textViewer, int invocationOffset) {
            return this.hoverRegion;
        }

        public String getInformation(ITextViewer textViewer, IRegion subject) {
            return this.hoverInfo.toString();
        }

        public Object getInformation2(ITextViewer textViewer, IRegion subject) {
            return this.hoverInfo;
        }

        public IInformationControlCreator getInformationPresenterControlCreator() {
            return this.controlCreator;
        }
    }

    public static class SizeConstraint {
        int horizontalWidthInChars;
        int verticalWidthInChars;
        boolean enforceAsMinimumSize;
        boolean enforceAsMaximumSize;

        public SizeConstraint(int horizontalWidthInChars, int verticalWidthInChars, boolean enforceAsMinimumSize, boolean enforceAsMaximumSize) {
            this.horizontalWidthInChars = horizontalWidthInChars;
            this.verticalWidthInChars = verticalWidthInChars;
            this.enforceAsMinimumSize = enforceAsMinimumSize;
            this.enforceAsMaximumSize = enforceAsMaximumSize;
        }
    }
}

