/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.runner;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.AccessLogValve;
import org.apache.tomcat.maven.runner.PasswordUtil;
import org.apache.tomcat.util.http.fileupload.FileUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;

public class Tomcat7Runner {
    public static final String USE_SERVER_XML_KEY = "useServerXml";
    public static final String WARS_KEY = "wars";
    public static final String ARCHIVE_GENERATION_TIMESTAMP_KEY = "generationTimestamp";
    public static final String ENABLE_NAMING_KEY = "enableNaming";
    public static final String ACCESS_LOG_VALVE_FORMAT_KEY = "accessLogValveFormat";
    public static final String HTTP_PROTOCOL_KEY = "connectorhttpProtocol";
    public int httpPort;
    public int httpsPort;
    public int ajpPort;
    public String serverXmlPath;
    public Properties runtimeProperties;
    public boolean resetExtract;
    public boolean debug = false;
    public boolean clientAuth = false;
    public String keyAlias = null;
    public String httpProtocol;
    public String extractDirectory = ".extract";
    public File extractDirectoryFile;
    public String loggerName;
    Catalina container;
    Tomcat tomcat;
    String uriEncoding = "ISO-8859-1";
    Map<String, String> webappWarPerContext = new HashMap<String, String>();

    public void run() throws Exception {
        String timestampValue;
        PasswordUtil.deobfuscateSystemProps();
        if (this.loggerName != null && this.loggerName.length() > 0) {
            this.installLogger(this.loggerName);
        }
        this.extractDirectoryFile = new File(this.extractDirectory);
        this.debugMessage("use extractDirectory:" + this.extractDirectoryFile.getPath());
        boolean archiveTimestampChanged = false;
        File timestampFile = new File(this.extractDirectoryFile, ".tomcat_executable_archive.timestamp");
        Properties timestampProps = this.loadProperties(timestampFile);
        if (timestampFile.exists() && (timestampValue = timestampProps.getProperty(ARCHIVE_GENERATION_TIMESTAMP_KEY)) != null) {
            long timestamp = Long.parseLong(timestampValue);
            archiveTimestampChanged = Long.parseLong(this.runtimeProperties.getProperty(ARCHIVE_GENERATION_TIMESTAMP_KEY)) > timestamp;
            this.debugMessage("read timestamp from file " + timestampValue + ", archiveTimestampChanged: " + archiveTimestampChanged);
        }
        if (!this.extractDirectoryFile.exists() || this.resetExtract || archiveTimestampChanged) {
            this.extract();
            if (archiveTimestampChanged || !timestampFile.exists()) {
                timestampProps.put(ARCHIVE_GENERATION_TIMESTAMP_KEY, this.runtimeProperties.getProperty(ARCHIVE_GENERATION_TIMESTAMP_KEY));
                this.saveProperties(timestampProps, timestampFile);
            }
        } else {
            String wars = this.runtimeProperties.getProperty(WARS_KEY);
            this.populateWebAppWarPerContext(wars);
        }
        new File(this.extractDirectory, "conf").mkdirs();
        new File(this.extractDirectory, "logs").mkdirs();
        new File(this.extractDirectory, "webapps").mkdirs();
        new File(this.extractDirectory, "work").mkdirs();
        File tmpDir = new File(this.extractDirectory, "temp");
        tmpDir.mkdirs();
        System.setProperty("java.io.tmpdir", tmpDir.getAbsolutePath());
        System.setProperty("catalina.base", this.extractDirectoryFile.getAbsolutePath());
        System.setProperty("catalina.home", this.extractDirectoryFile.getAbsolutePath());
        if (this.serverXmlPath != null || this.useServerXml()) {
            this.container = new Catalina();
            this.container.setUseNaming(this.enableNaming());
            if (this.serverXmlPath != null && new File(this.serverXmlPath).exists()) {
                this.container.setConfig(this.serverXmlPath);
            } else {
                this.container.setConfig(new File(this.extractDirectory, "conf/server.xml").getAbsolutePath());
            }
            this.container.start();
        } else {
            this.tomcat = new Tomcat(){

                public Context addWebapp(Host host, String url, String name, String path) {
                    StandardContext ctx = new StandardContext();
                    ctx.setName(name);
                    ctx.setPath(url);
                    ctx.setDocBase(path);
                    ContextConfig ctxCfg = new ContextConfig();
                    ctx.addLifecycleListener(ctxCfg);
                    ctxCfg.setDefaultWebXml(new File(Tomcat7Runner.this.extractDirectory, "conf/web.xml").getAbsolutePath());
                    if (host == null) {
                        this.getHost().addChild(ctx);
                    } else {
                        host.addChild(ctx);
                    }
                    return ctx;
                }
            };
            if (this.enableNaming()) {
                System.setProperty("catalina.useNaming", "true");
                this.tomcat.enableNaming();
            }
            this.tomcat.getHost().setAppBase(new File(this.extractDirectory, "webapps").getAbsolutePath());
            String connectorHttpProtocol = this.runtimeProperties.getProperty(HTTP_PROTOCOL_KEY);
            if (this.httpProtocol != null && this.httpProtocol.trim().length() > 0) {
                connectorHttpProtocol = this.httpProtocol;
            }
            this.debugMessage("use connectorHttpProtocol:" + connectorHttpProtocol);
            if (this.httpPort > 0) {
                Connector connector = new Connector(connectorHttpProtocol);
                connector.setPort(this.httpPort);
                if (this.httpsPort > 0) {
                    connector.setRedirectPort(this.httpsPort);
                }
                connector.setURIEncoding(this.uriEncoding);
                this.tomcat.getService().addConnector(connector);
                this.tomcat.setConnector(connector);
            }
            AccessLogValve alv = new AccessLogValve();
            alv.setDirectory(new File(this.extractDirectory, "logs").getAbsolutePath());
            alv.setPattern(this.runtimeProperties.getProperty(ACCESS_LOG_VALVE_FORMAT_KEY));
            this.tomcat.getHost().getPipeline().addValve(alv);
            if (this.httpsPort > 0) {
                Connector httpsConnector = new Connector(connectorHttpProtocol);
                httpsConnector.setPort(this.httpsPort);
                httpsConnector.setSecure(true);
                httpsConnector.setProperty("SSLEnabled", "true");
                httpsConnector.setProperty("sslProtocol", "TLS");
                httpsConnector.setURIEncoding(this.uriEncoding);
                String keystoreFile = System.getProperty("javax.net.ssl.keyStore");
                String keystorePass = System.getProperty("javax.net.ssl.keyStorePassword");
                String keystoreType = System.getProperty("javax.net.ssl.keyStoreType", "jks");
                if (keystoreFile != null) {
                    httpsConnector.setAttribute("keystoreFile", keystoreFile);
                }
                if (keystorePass != null) {
                    httpsConnector.setAttribute("keystorePass", keystorePass);
                }
                httpsConnector.setAttribute("keystoreType", keystoreType);
                String truststoreFile = System.getProperty("javax.net.ssl.trustStore");
                String truststorePass = System.getProperty("javax.net.ssl.trustStorePassword");
                String truststoreType = System.getProperty("javax.net.ssl.trustStoreType", "jks");
                if (truststoreFile != null) {
                    httpsConnector.setAttribute("truststoreFile", truststoreFile);
                }
                if (truststorePass != null) {
                    httpsConnector.setAttribute("truststorePass", truststorePass);
                }
                httpsConnector.setAttribute("truststoreType", truststoreType);
                httpsConnector.setAttribute("clientAuth", this.clientAuth);
                httpsConnector.setAttribute("keyAlias", this.keyAlias);
                this.tomcat.getService().addConnector(httpsConnector);
                if (this.httpPort <= 0) {
                    this.tomcat.setConnector(httpsConnector);
                }
            }
            if (this.ajpPort > 0) {
                Connector ajpConnector = new Connector("org.apache.coyote.ajp.AjpProtocol");
                ajpConnector.setPort(this.ajpPort);
                ajpConnector.setURIEncoding(this.uriEncoding);
                this.tomcat.getService().addConnector(ajpConnector);
            }
            for (Map.Entry<String, String> entry : this.webappWarPerContext.entrySet()) {
                URL contextFileUrl;
                String baseDir = null;
                Context context = null;
                if (entry.getKey().equals("/")) {
                    baseDir = new File(this.extractDirectory, "webapps/ROOT.war").getAbsolutePath();
                    context = this.tomcat.addWebapp("", baseDir);
                } else {
                    baseDir = new File(this.extractDirectory, "webapps/" + entry.getValue()).getAbsolutePath();
                    context = this.tomcat.addWebapp(entry.getKey(), baseDir);
                }
                if ((contextFileUrl = this.getContextXml(baseDir)) == null) continue;
                context.setConfigFile(contextFileUrl);
            }
            this.tomcat.start();
        }
        this.waitIndefinitely();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URL getContextXml(String warPath) throws IOException {
        InputStream inputStream = null;
        try {
            String urlStr = "jar:file:" + warPath + "!/META-INF/context.xml";
            this.debugMessage("search context.xml in url:'" + urlStr + "'");
            URL url = new URL(urlStr);
            inputStream = url.openConnection().getInputStream();
            if (inputStream != null) {
                URL uRL = url;
                IOUtils.closeQuietly(inputStream);
                return uRL;
            }
            IOUtils.closeQuietly(inputStream);
        }
        catch (FileNotFoundException e) {
            URL uRL = null;
            return uRL;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIndefinitely() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            try {
                lock.wait();
            }
            catch (InterruptedException exception) {
                throw new Error("InterruptedException on wait Indefinitely lock:" + exception.getMessage(), exception);
            }
        }
    }

    public void stop() throws Exception {
        if (this.container != null) {
            this.container.stop();
        }
        if (this.tomcat != null) {
            this.tomcat.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extract() throws Exception {
        boolean created;
        if (this.extractDirectoryFile.exists()) {
            this.debugMessage("delete extractDirectory:" + this.extractDirectoryFile.getAbsolutePath());
            FileUtils.deleteDirectory(this.extractDirectoryFile);
        }
        if (!this.extractDirectoryFile.exists() && !(created = this.extractDirectoryFile.mkdirs())) {
            throw new Exception("FATAL: impossible to create directory:" + this.extractDirectoryFile.getPath());
        }
        created = new File(this.extractDirectory, "webapps").mkdirs();
        if (!created) {
            throw new Exception("FATAL: impossible to create directory:" + this.extractDirectoryFile.getPath() + "/webapps");
        }
        String wars = this.runtimeProperties.getProperty(WARS_KEY);
        this.populateWebAppWarPerContext(wars);
        for (Map.Entry<String, String> entry : this.webappWarPerContext.entrySet()) {
            this.debugMessage("webappWarPerContext entry key/value: " + entry.getKey() + "/" + entry.getValue());
            InputStream inputStream = null;
            try {
                File expandFile;
                inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(entry.getValue());
                if (!this.useServerXml()) {
                    if (entry.getKey().equals("/")) {
                        expandFile = new File(this.extractDirectory, "webapps/ROOT.war");
                        this.debugMessage("expand to file:" + expandFile.getPath());
                        Tomcat7Runner.expand(inputStream, expandFile);
                        continue;
                    }
                    expandFile = new File(this.extractDirectory, "webapps/" + entry.getValue());
                    this.debugMessage("expand to file:" + expandFile.getPath());
                    Tomcat7Runner.expand(inputStream, expandFile);
                    continue;
                }
                expandFile = new File(this.extractDirectory, "webapps/" + entry.getValue());
                this.debugMessage("expand to file:" + expandFile.getPath());
                Tomcat7Runner.expand(inputStream, new File(this.extractDirectory, "webapps/" + entry.getValue()));
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        Tomcat7Runner.expandConfigurationFile("catalina.properties", this.extractDirectoryFile);
        Tomcat7Runner.expandConfigurationFile("logging.properties", this.extractDirectoryFile);
        Tomcat7Runner.expandConfigurationFile("tomcat-users.xml", this.extractDirectoryFile);
        Tomcat7Runner.expandConfigurationFile("catalina.policy", this.extractDirectoryFile);
        Tomcat7Runner.expandConfigurationFile("context.xml", this.extractDirectoryFile);
        Tomcat7Runner.expandConfigurationFile("server.xml", this.extractDirectoryFile);
        Tomcat7Runner.expandConfigurationFile("web.xml", this.extractDirectoryFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expandConfigurationFile(String fileName, File extractDirectory) throws Exception {
        InputStream inputStream = null;
        try {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("conf/" + fileName);
            if (inputStream != null) {
                File confDirectory = new File(extractDirectory, "conf");
                if (!confDirectory.exists()) {
                    confDirectory.mkdirs();
                }
                Tomcat7Runner.expand(inputStream, new File(confDirectory, fileName));
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void populateWebAppWarPerContext(String warsValue) {
        StringTokenizer st = new StringTokenizer(warsValue, ";");
        while (st.hasMoreTokens()) {
            String warValue = st.nextToken();
            this.debugMessage("populateWebAppWarPerContext warValue:" + warValue);
            String warFileName = "";
            String contextValue = "";
            int separatorIndex = warValue.indexOf("|");
            if (separatorIndex >= 0) {
                warFileName = warValue.substring(0, separatorIndex);
                contextValue = warValue.substring(separatorIndex + 1, warValue.length());
            } else {
                warFileName = contextValue;
            }
            this.debugMessage("populateWebAppWarPerContext contextValue/warFileName:" + contextValue + "/" + warFileName);
            this.webappWarPerContext.put(contextValue, warFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void expand(InputStream input, File file) throws IOException {
        FilterOutputStream output = null;
        try {
            int n;
            output = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[2048];
            while ((n = input.read(buffer)) > 0) {
                ((BufferedOutputStream)output).write(buffer, 0, n);
            }
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean useServerXml() {
        return Boolean.parseBoolean(this.runtimeProperties.getProperty(USE_SERVER_XML_KEY, Boolean.FALSE.toString()));
    }

    public void debugMessage(String message) {
        if (this.debug) {
            System.out.println(message);
        }
    }

    public boolean enableNaming() {
        return Boolean.parseBoolean(this.runtimeProperties.getProperty(ENABLE_NAMING_KEY, Boolean.FALSE.toString()));
    }

    private void installLogger(String loggerName) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if ("slf4j".equals(loggerName)) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass("org.slf4j.bridge.SLF4JBridgeHandler");
                LogManager.getLogManager().reset();
                Method method = clazz.getMethod("install", null);
                method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                System.out.println("WARNING: issue configuring slf4j jul bridge, skip it");
            }
        } else {
            System.out.println("WARNING: loggerName " + loggerName + " not supported, skip it");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadProperties(File file) throws FileNotFoundException, IOException {
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                properties.load(fileInputStream);
            }
            finally {
                fileInputStream.close();
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveProperties(Properties properties, File file) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            properties.store(fileOutputStream, "Timestamp file for executable war/jar");
        }
        finally {
            fileOutputStream.close();
        }
    }
}

