/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.rcp;

import org.eclipse.dirigible.repository.rcp.RCPBaseException;
import org.eclipse.dirigible.repository.rcp.RCPObject;
import org.eclipse.dirigible.repository.rcp.RCPRepository;

public class RCPFile
extends RCPObject {
    private boolean binary = false;
    private String contentType;

    public RCPFile(RCPRepository repository, boolean isBinary, String contentType) {
        super(repository);
        this.binary = isBinary;
        this.contentType = contentType;
    }

    public void delete() throws RCPBaseException {
        this.getRepository().getRepositoryDAO().removeFileByPath(this.getPath());
    }

    public void rename(String newPath) throws RCPBaseException {
        this.getRepository().getRepositoryDAO().renameFile(this.getPath(), newPath);
    }

    public byte[] getData() throws RCPBaseException {
        return this.getRepository().getRepositoryDAO().getFileContent(this);
    }

    public void setData(byte[] content) throws RCPBaseException {
        this.getRepository().getRepositoryDAO().setFileContent(this, content);
    }

    public boolean isBinary() {
        return this.binary;
    }

    public String getContentType() {
        return this.contentType;
    }
}

