/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.status.DefaultProgressMonitor;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.jgit.command.Messages;
import org.eclipse.dirigible.ide.jgit.utils.CommandHandlerUtils;
import org.eclipse.dirigible.ide.workspace.ui.commands.AbstractWorkspaceHandler;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public class ResetCommandHandler
extends AbstractWorkspaceHandler {
    private static final String TASK_RESETING_PROJECT = Messages.ResetCommandHandler_TASK_RESETING_PROJECT;
    private static final String PROJECT_S_SUCCESSFULY_RESETED = Messages.ResetCommandHandler_PROJECT_S_SUCCESSFULY_RESETED;
    private static final String DO_YOU_REALLY_WANT_TO_HARD_RESET_PROJECT_S = Messages.HardResetCommandHandler_DO_YOU_REALLY_WANT_TO_HARD_RESET_PROJECT_S;
    private static final String HARD_RESET = Messages.HardResetCommandHandler_HARD_RESET;
    private static final String SLASH = "/";
    private static final String DOT_GIT = ".git";
    private static final String MASTER = "master";
    private static final String ONLY_ONE_PROJECT_CAN_BE_HARD_RESETED_AT_A_TIME = Messages.HardResetCommandHandler_ONLY_ONE_PROJECT_CAN_BE_HARD_RESETED_AT_A_TIME;
    private static final String PLEASE_SELECT_ONE = Messages.HardResetCommandHandler_PLEASE_SELECT_ONE;
    private static final String NO_PROJECT_IS_SELECTED_FOR_HARD_RESET = Messages.HardResetCommandHandler_NO_PROJECT_IS_SELECTED_FOR_HARD_RESET;
    private static final String WHILE_HARD_RESETING_PROJECT_ERROR_OCCURED = Messages.HardResetCommandHandler_WHILE_HARD_RESETING_PROJECT_ERROR_OCCURED;
    private static final String ERROR_DURING_HARD_RESET = Messages.HardResetCommandHandler_ERROR_DURING_HARD_RESET;
    private static final String INCORRECT_USERNAME_AND_OR_PASSWORD_OR_GIT_REPOSITORY_URI = Messages.HardResetCommandHandler_reset;
    private static final String PLEASE_CHECK_IF_PROXY_SETTINGS_ARE_SET_PROPERLY = Messages.HardResetCommandHandler_PLEASE_CHECK_IF_PROXY_SETTINGS_ARE_SET_PROPERLY;
    private static final Logger logger = Logger.getLogger(ResetCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        IProject[] projects = CommandHandlerUtils.getProjects(selection, logger);
        if (projects.length == 0) {
            logger.warn(NO_PROJECT_IS_SELECTED_FOR_HARD_RESET);
            StatusLineManagerUtil.setWarningMessage((String)NO_PROJECT_IS_SELECTED_FOR_HARD_RESET);
            MessageDialog.openWarning(null, (String)NO_PROJECT_IS_SELECTED_FOR_HARD_RESET, (String)PLEASE_SELECT_ONE);
            return null;
        }
        if (projects.length > 1) {
            logger.warn(ONLY_ONE_PROJECT_CAN_BE_HARD_RESETED_AT_A_TIME);
            StatusLineManagerUtil.setWarningMessage((String)ONLY_ONE_PROJECT_CAN_BE_HARD_RESETED_AT_A_TIME);
            MessageDialog.openWarning(null, (String)ONLY_ONE_PROJECT_CAN_BE_HARD_RESETED_AT_A_TIME, (String)PLEASE_SELECT_ONE);
            return null;
        }
        IProject project = projects[0];
        Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        String message = String.format(DO_YOU_REALLY_WANT_TO_HARD_RESET_PROJECT_S, project.getName());
        DefaultProgressMonitor monitor = new DefaultProgressMonitor();
        monitor.beginTask(TASK_RESETING_PROJECT, -1);
        boolean confirmed = MessageDialog.openConfirm((Shell)parent, (String)HARD_RESET, (String)message);
        if (confirmed) {
            this.hardReset(project);
        }
        monitor.done();
        return null;
    }

    /*
     * Exception decompiling
     */
    private void hardReset(IProject project) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

