/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import com.google.gson.Gson;
import java.io.IOException;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.DebugConfiguration;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.DebuggerPausedRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.EmptyResponse;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.models.Location;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.DebuggingService;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.RequestUtils;

public class DebuggerStepHandler
implements MessageHandler {
    private static final Gson GSON = new Gson();

    @Override
    public void handle(String message, Session session) throws IOException {
        EmptyResponse response = new EmptyResponse(RequestUtils.getMessageId(message));
        MessageDispatcher.sendMessage(GSON.toJson((Object)response), session);
        if (RequestUtils.isStepIntoMessage(message)) {
            this.handleStepInto(message, session);
        } else if (RequestUtils.isStepOutMessage(message)) {
            this.handleStepOut(message, session);
        } else if (RequestUtils.isStepOverMessage(message)) {
            this.handleStepOver(message, session);
        }
    }

    private void handleStepOver(String message, Session session) {
        DebuggerPausedRequest.sendRequest(session);
        DebuggingService.stepOver(session.getUserPrincipal().getName(), this.getBreakpointLine(session));
    }

    private void handleStepOut(String message, Session session) {
        DebuggerPausedRequest.sendRequest(session);
        DebuggingService.stepOut(session.getUserPrincipal().getName(), this.getBreakpointLine(session));
    }

    private void handleStepInto(String message, Session session) {
        DebuggerPausedRequest.sendRequest(session);
        DebuggingService.stepInto(session.getUserPrincipal().getName(), this.getBreakpointLine(session));
    }

    private int getBreakpointLine(Session session) {
        Location currentExecutionLocation = DebugConfiguration.getCurrentExecutionLocation(session.getUserPrincipal().getName());
        return currentExecutionLocation.getLineNumber().intValue();
    }
}

