/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.chrome.debugger.handlers;

import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.websocket.Session;
import org.eclipse.dirigible.runtime.chrome.debugger.communication.MessageRequest;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.MessageHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.handlers.OnExceptionHandler;
import org.eclipse.dirigible.runtime.chrome.debugger.processing.MessageDispatcher;
import org.eclipse.dirigible.runtime.chrome.debugger.utils.RequestUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class GetPropertiesHandler
implements MessageHandler {
    private static final Gson GSON = new Gson();

    @Override
    public void handle(String message, Session session) throws IOException {
        MessageRequest request = (MessageRequest)GSON.fromJson(message, MessageRequest.class);
        Map<String, Object> params = request.getParams();
        String objectId = (String)params.get("objectId");
        this.sendVariableInfo(message, objectId, session);
    }

    private void sendVariableInfo(String message, String objectId, Session session) throws IOException {
        ArrayList variables = new ArrayList();
        Integer id = RequestUtils.getMessageId(message);
        JSONObject result = new JSONObject();
        try {
            result.put("result", variables);
            JSONObject response = new JSONObject();
            response.put("id", (Object)id);
            response.put("result", (Object)result);
        }
        catch (JSONException e) {
            new OnExceptionHandler().handle(e.getMessage(), session);
        }
        MessageDispatcher.sendMessage(result.toString(), session);
    }
}

