/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.html.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.html.wizard.TableColumn;
import org.eclipse.dirigible.ide.ui.common.validation.IValidationStatus;
import org.eclipse.dirigible.ide.ui.common.validation.ValidationStatus;

public class HtmlForEntityTemplateModel
extends GenerationModel {
    private static final String TARGET_LOCATION_IS_NOT_ALLOWED = Messages.HtmlForEntityTemplateModel_TARGET_LOCATION_IS_NOT_ALLOWED;
    private String tableName;
    private String tableType;
    private TableColumn[] tableColumns;
    private String pageTitle;
    private String serviceEndpoint;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public TableColumn[] getOriginalTableColumns() {
        return this.tableColumns;
    }

    public TableColumn[] getTableColumns() {
        TableColumn[] originalCased = this.tableColumns;
        TableColumn[] lowerCased = new TableColumn[originalCased.length];
        int i = 0;
        while (i < originalCased.length) {
            TableColumn lowerColumn;
            TableColumn originalColumn = originalCased[i];
            lowerCased[i] = lowerColumn = new TableColumn(originalColumn.getName().toLowerCase(), originalColumn.isKey(), originalColumn.isVisible(), originalColumn.getType(), originalColumn.getSize(), originalColumn.getWidgetType(), originalColumn.getLabel());
            ++i;
        }
        return lowerCased;
    }

    public void setTableColumns(TableColumn[] tableColumns) {
        this.tableColumns = tableColumns;
    }

    public void setTableType(String tableType) {
        this.tableType = tableType;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public IValidationStatus validate() {
        IValidationStatus locationStatus = this.validateLocation();
        if (locationStatus.hasErrors()) {
            return locationStatus;
        }
        IValidationStatus templateStatus = this.validateTemplate();
        if (locationStatus.hasErrors()) {
            return locationStatus;
        }
        return ValidationStatus.getValidationStatus((IValidationStatus)locationStatus, (IValidationStatus)templateStatus);
    }

    public IValidationStatus validateLocation() {
        IValidationStatus status;
        try {
            status = this.validateLocationGeneric();
            if (status.hasErrors()) {
                return status;
            }
            IPath location = new Path(this.getTargetLocation()).append(this.getFileName());
            if (location.toString().indexOf("WebContent") == -1) {
                return ValidationStatus.createError((String)TARGET_LOCATION_IS_NOT_ALLOWED);
            }
        }
        catch (Exception exception) {
            return ValidationStatus.createError((String)"");
        }
        return status;
    }

    public boolean validateTableColumns() {
        TableColumn[] tableColumnArray = this.tableColumns;
        int n = this.tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            if (tableColumn.isVisible()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IFile getSourceFile() {
        IResource resource = this.getSourceResource();
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }
}

