/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.table.ContentForEntityModel;
import org.eclipse.dirigible.ide.template.ui.common.table.TableColumn;
import org.eclipse.dirigible.repository.logging.Logger;

public class HtmlForEntityTemplateGenerator
extends TemplateGenerator {
    private static final Logger logger = Logger.getLogger(HtmlForEntityTemplateGenerator.class);
    private static final String LOG_TAG = "HTML_FOR_ENTITY_GENERATOR";
    private static final String REST_SERVICE_ROOT_JS = "../../js";
    private static final String PARAMETER_PAGE_TITLE = "pageTitle";
    private static final String PARAMETER_TABLE_NAME = "tableName";
    private static final String PARAMETER_DEPENDENT_COLUMN = "dependentColumn";
    private static final String PARAMETER_TABLE_COLUMNS = "tableColumns";
    private static final String PARAMETER_SERVICE_FILE_NAME = "serviceFileName";
    private static final String PARAMETER_ENTITY_NAME = "entityName";
    private static final String PARAMETER_PRIMARY_KEY = "primaryKey";
    private ContentForEntityModel model;

    public HtmlForEntityTemplateGenerator(ContentForEntityModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        Map parameters = super.prepareParameters();
        parameters.put(PARAMETER_PAGE_TITLE, this.model.getPageTitle());
        parameters.put(PARAMETER_TABLE_NAME, this.model.getTableName());
        parameters.put(PARAMETER_DEPENDENT_COLUMN, this.model.getDependentColumn());
        parameters.put(PARAMETER_TABLE_COLUMNS, this.model.getTableColumns());
        parameters.put(PARAMETER_SERVICE_FILE_NAME, this.generateServiceFileName());
        parameters.put(PARAMETER_ENTITY_NAME, this.getEntityName());
        parameters.put(PARAMETER_PRIMARY_KEY, this.getPrimaryKey());
        return parameters;
    }

    private Object getPrimaryKey() {
        TableColumn[] columns = this.model.getTableColumns();
        TableColumn primaryKey = null;
        TableColumn[] tableColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            if (column.isKey()) {
                primaryKey = column;
            }
            ++n2;
        }
        if (primaryKey == null) {
            logger.error(String.format("There is no primary key in table %s, which can produce errornous artifacts", this.model.getTableName()));
            return null;
        }
        return primaryKey;
    }

    protected String getEntityName() {
        return "data";
    }

    protected Object generateServiceFileName() {
        String result = "";
        if (this.model.getSourceFile() != null) {
            IFile source = this.model.getSourceFile();
            String entityPath = source.getFullPath().toString();
            int index = entityPath.indexOf("ScriptingServices");
            result = index >= 0 ? entityPath.substring(index + "ScriptingServices".length()) : entityPath;
            result = result.replace(source.getFileExtension(), "");
            result = String.valueOf(result) + "js";
        } else {
            result = this.model.getServiceEndpoint();
        }
        return REST_SERVICE_ROOT_JS + result;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        return this.model.normalizeEscapes(bytes);
    }

    protected String getDefaultRootFolder() {
        return "WebContent";
    }
}

