/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.server.bespin;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.server.bespin.JSONUtil;

public class MarkersServlet
extends HttpServlet {
    private IWorkspace workspace;

    private synchronized IWorkspace getWorkspace() {
        if (this.workspace == null) {
            new InstanceScope().getNode("org.eclipse.core.resources").putBoolean("refresh.enabled", true);
            this.workspace = ResourcesPlugin.getWorkspace();
        }
        return this.workspace;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        if (pathInfo.startsWith("/at/")) {
            String wsPath = pathInfo.substring("/at".length());
            IResource resource = this.getWorkspace().getRoot().findMember((IPath)new Path(wsPath));
            if (resource.getType() != 1) {
                resp.setStatus(405);
                return;
            }
            PrintWriter writer = resp.getWriter();
            try {
                IMarker[] markers = resource.findMarkers(null, true, 0);
                resp.setStatus(200);
                resp.setContentType("application/json; charset=UTF-8");
                ArrayList jsonArray = new ArrayList();
                int i = 0;
                while (i < markers.length) {
                    HashMap<String, Object> jsonObject = new HashMap<String, Object>();
                    jsonObject.put("message", ("" + markers[i].getAttribute("message")).replace('\"', '\''));
                    jsonObject.put("severity", ("" + markers[i].getAttribute("severity")).replace('\"', '\''));
                    jsonObject.put("line", markers[i].getAttribute("lineNumber"));
                    jsonArray.add(jsonObject);
                    ++i;
                }
                writer.write(JSONUtil.write(jsonArray));
                return;
            }
            catch (Exception e) {
                e.printStackTrace(writer);
                resp.setStatus(500);
                return;
            }
        }
        super.doGet(req, resp);
    }
}

