/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.tags;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.tags.TagSelectionArea;
import org.eclipse.team.internal.ccvs.ui.tags.TagSource;
import org.eclipse.team.internal.ccvs.ui.wizards.CVSWizardPage;
import org.eclipse.team.internal.ui.PixelConverter;
import org.eclipse.team.internal.ui.SWTUtils;
import org.eclipse.ui.PlatformUI;

public class TagSelectionWizardPage
extends CVSWizardPage {
    private CVSTag selectedTag;
    private Composite composite;
    private int includeFlags;
    boolean allowNoTag = false;
    private Button useResourceTagButton;
    private Button selectTagButton;
    private boolean useResourceTag = false;
    private String helpContextId;
    private TagSelectionArea tagArea;
    private TagSource tagSource;

    public TagSelectionWizardPage(String pageName, String title, ImageDescriptor titleImage, String description, TagSource tagSource, int includeFlags) {
        super(pageName, title, titleImage, description);
        this.tagSource = tagSource;
        this.includeFlags = includeFlags;
    }

    public void setHelpContxtId(String helpContextId) {
        this.helpContextId = helpContextId;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = SWTUtils.createDialogPixelConverter((Control)parent);
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)SWTUtils.createGridLayout((int)1, (PixelConverter)converter, (int)-1));
        this.composite.setLayoutData((Object)SWTUtils.createHVFillGridData());
        this.setControl((Control)this.composite);
        if (this.helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, this.helpContextId);
        }
        if (this.allowNoTag) {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TagSelectionWizardPage.this.useResourceTag = TagSelectionWizardPage.this.useResourceTagButton.getSelection();
                    TagSelectionWizardPage.this.updateEnablement();
                }
            };
            this.useResourceTag = true;
            this.useResourceTagButton = this.createRadioButton(this.composite, CVSUIMessages.TagSelectionWizardPage_0, 1);
            this.selectTagButton = this.createRadioButton(this.composite, CVSUIMessages.TagSelectionWizardPage_1, 1);
            this.useResourceTagButton.setSelection(this.useResourceTag);
            this.selectTagButton.setSelection(!this.useResourceTag);
            this.useResourceTagButton.addSelectionListener((SelectionListener)listener);
            this.selectTagButton.addSelectionListener((SelectionListener)listener);
        }
        this.createTagArea();
        this.updateEnablement();
        Dialog.applyDialogFont((Control)parent);
    }

    private void createTagArea() {
        this.tagArea = new TagSelectionArea(this.getShell(), this.tagSource, this.includeFlags, null);
        this.tagArea.setRunnableContext((IRunnableContext)this.getContainer());
        this.tagArea.createArea(this.composite);
        this.tagArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("selectedTag")) {
                    TagSelectionWizardPage.this.selectedTag = TagSelectionWizardPage.this.tagArea.getSelection();
                    TagSelectionWizardPage.this.updateEnablement();
                } else if (event.getProperty().equals("openSelectedTag") && TagSelectionWizardPage.this.selectedTag != null) {
                    TagSelectionWizardPage.this.gotoNextPage();
                }
            }
        });
        this.refreshTagArea();
    }

    private void refreshTagArea() {
        if (this.tagArea != null) {
            this.tagArea.refresh();
            this.tagArea.setSelection(this.selectedTag);
        }
    }

    protected void updateEnablement() {
        this.tagArea.setEnabled(!this.useResourceTag);
        this.setPageComplete(this.useResourceTag || this.selectedTag != null);
    }

    public CVSTag getSelectedTag() {
        if (this.useResourceTag) {
            return null;
        }
        return this.selectedTag;
    }

    protected void gotoNextPage() {
        this.getContainer().showPage(this.getNextPage());
    }

    public void setAllowNoTag(boolean b) {
        this.allowNoTag = b;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.tagArea != null) {
            this.tagArea.setFocus();
            if (CVSUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_auto_refresh_tags_in_tag_selection_dialog")) {
                this.tagArea.refreshTagList();
            }
        }
    }

    public void setTagSource(TagSource source) {
        this.tagSource = source;
        this.tagArea.setTagSource(this.tagSource);
        this.setSelection(null);
        this.refreshTagArea();
    }

    public void setSelection(CVSTag selectedTag) {
        this.selectedTag = selectedTag == null && (this.includeFlags & 1) > 0 ? CVSTag.DEFAULT : selectedTag;
    }
}

